/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import express.Express;
import express.middleware.CorsOptions;
import express.middleware.Middleware;
import express.utils.MediaType;
import express.utils.Status;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_3518;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.AlinLogger;
import ru.kelcuprum.alinlib.utils.GsonHelper;
import ru.pplh.mod.PepeLandHelper;
import ru.pplh.mod.api.PepeLandAPI;
import ru.pplh.mod.api.components.user.User;
import ru.pplh.mod.utils.WebUtils;

public class OAuth {
    public static boolean state = false;
    public static boolean corsSetting = false;
    public static AlinLogger logger = new AlinLogger("PPL Helper/OAuth");
    public static Express app = new Express(PepeLandHelper.config.getString("oauth.hostname", "127.0.0.1"));
    public static String htmlAuth;

    public static String getURI(String url) {
        return OAuth.getURI(url, true);
    }

    public static String getURI(String url, boolean uriEncode) {
        Object api = PepeLandHelper.config.getString("oauth.url", "https://auth.pplh.ru/");
        if (!((String)api).endsWith("/")) {
            api = (String)api + "/";
        }
        if (url.startsWith("/")) {
            url = url.substring(1);
        }
        return String.format("%1$s%2$s", api, uriEncode ? PepeLandAPI.uriEncode(url) : url);
    }

    public static void run() {
        app = new Express(PepeLandHelper.config.getString("oauth.hostname", "127.0.0.1"));
        try {
            InputStream releaseFile = PepeLandHelper.class.getResourceAsStream("/www/auth.html");
            if (releaseFile != null) {
                htmlAuth = new String(releaseFile.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        if (!corsSetting) {
            corsSetting = true;
            CorsOptions corsOptions = new CorsOptions();
            corsOptions.setOrigin("*");
            corsOptions.setAllowCredentials(true);
            corsOptions.setHeaders(new String[]{"GET", "POST"});
        }
        app.use(Middleware.cors());
        app.use((req, res) -> logger.log(String.format("%s \u0441\u0434\u0435\u043b\u0430\u043b \u0437\u0430\u043f\u0440\u043e\u0441 \u043d\u0430 %s", req.getIp(), req.getPath())));
        app.all("/", (req, res) -> {
            String location = String.format("https://id.twitch.tv/oauth2/authorize?response_type=token&client_id=%1$s&redirect_uri=%2$s", PepeLandAPI.uriEncode(PepeLandHelper.config.getString("oauth.client_id", "n0wrmdd14dpmcmlkfwmtgel5bu1ev5")), PepeLandAPI.uriEncode(PepeLandHelper.config.getString("oauth.redirect_uri", "http://localhost:11430/auth")));
            res.redirect(location);
        });
        app.all("/avatar/:id", (req, res) -> res.redirect(OAuth.getURI("avatar/" + req.getParam("id"), false)));
        app.all("/auth", (req, res) -> {
            if (req.getContentType().toLowerCase().contains("application/json") || req.getQuery("json") != null && req.getQuery("json").equalsIgnoreCase("true") || htmlAuth == null) {
                if (req.getQuery("code").isEmpty()) {
                    res.setStatus(Status._401);
                    res.json((JsonElement)Objects.UNAUTHORIZED);
                    return;
                }
                try {
                    JsonObject jsonObject = WebUtils.getJsonObject(OAuth.getURI("login", false) + "?code=" + req.getQuery("code") + "&mc_uuid=" + String.valueOf(AlinLib.MINECRAFT.method_1548().method_44717()) + "&json=true&ruri=" + PepeLandAPI.uriEncode(PepeLandHelper.config.getString("oauth.redirect_uri", "http://127.0.0.1:11430/auth")));
                    if (jsonObject.has("error")) {
                        res.setStatus(Integer.parseInt(GsonHelper.getStringInJSON((String)"error.code", (JsonObject)jsonObject, (String)"500")));
                    } else {
                        PepeLandHelper.config.setString("oauth.access_token", GsonHelper.getStringInJSON((String)"access", (JsonObject)jsonObject, (String)""));
                        PepeLandHelper.loadUser(true);
                    }
                    res.json((JsonElement)jsonObject);
                }
                catch (Exception e) {
                    res.setStatus(500);
                    res.json((JsonElement)OAuth.getErrorObject(e));
                }
            } else {
                res.setContentType(MediaType._html);
                res.send(htmlAuth);
            }
        });
        app.all((req, res) -> {
            res.setStatus(404);
            res.json((JsonElement)Objects.NOT_FOUND);
        });
        app.listen(Integer.parseInt(PepeLandHelper.config.getString("oauth.port", "11430")));
        logger.log("API Started");
        logger.log("Open: http://localhost:%s", new Object[]{Integer.parseInt(PepeLandHelper.config.getString("oauth.port", "11430"))});
        state = true;
    }

    public static void stop() {
        if (state) {
            app.stop();
            logger.log("API Stopped");
        } else {
            logger.warn("API not running");
        }
    }

    public static JsonObject getErrorObject(Exception ex) {
        JsonObject object = Objects.INTERNAL_SERVER_ERROR;
        object.get("error").getAsJsonObject().addProperty("message", ex.getMessage() == null ? ex.getClass().toString() : ex.getMessage());
        return object;
    }

    public static User getUser(String token) {
        try {
            JsonObject object = WebUtils.getJsonObject(HttpRequest.newBuilder(URI.create(OAuth.getURI("user/me", false))).header("Authorization", "Bearer " + token));
            PepeLandHelper.LOG.log(object.toString());
            if (object.has("error")) {
                return null;
            }
            return new User(object);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static User getUserByID(String id) {
        try {
            JsonObject object = WebUtils.getJsonObject(OAuth.getURI(String.format("user/%s", id), false));
            if (object.has("error")) {
                return null;
            }
            return new User(object);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static interface Objects {
        public static final JsonObject NOT_FOUND = class_3518.method_15285((String)"{\"error\":{\"code\":404,\"codename\":\"Not found\",\"message\":\"Method not found\"}}");
        public static final JsonObject INTERNAL_SERVER_ERROR = class_3518.method_15285((String)"{\"error\":{\"code\":500,\"codename\":\"Internal Server Error\",\"message\":\"\"}}");
        public static final JsonObject UNAUTHORIZED = class_3518.method_15285((String)"{\"error\": {\"code\": 401,\"codename\": \"Unauthorized\",\"message\": \"You not authorized\"}}");
        public static final JsonObject BAD_REQUEST = class_3518.method_15285((String)"{\"error\": {\"code\": 400,\"codename\": \"Bad Request\",\"message\": \"The required arguments are missing!\"}}");
    }
}

