/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.api.components;

import com.google.gson.JsonObject;
import java.util.HashMap;
import ru.kelcuprum.alinlib.utils.GsonHelper;
import ru.pplh.mod.PepeLandHelper;
import ru.pplh.mod.utils.WebUtils;

public class ResourcePack {
    public String id;
    public Service service;
    public String title;
    public String description;
    public String url;
    public String icon;
    public static HashMap<String, JsonObject> cache = new HashMap();

    public ResourcePack(JsonObject info) {
        this.id = GsonHelper.getStringInJSON((String)"id", (JsonObject)info);
        this.service = Service.getServiceByID(GsonHelper.getStringInJSON((String)"service", (JsonObject)info, (String)""));
        this.icon = GsonHelper.getStringInJSON((String)"icon", (JsonObject)info, (String)"");
        this.title = GsonHelper.getStringInJSON((String)"title", (JsonObject)info, (String)"");
        this.description = GsonHelper.getStringInJSON((String)"description", (JsonObject)info, (String)"");
        this.url = !GsonHelper.jsonElementIsNull((String)"url", (JsonObject)info) ? GsonHelper.getStringInJSON((String)"url", (JsonObject)info, (String)"") : Service.getServiceURL(this.service, this.id);
        new Thread(() -> {
            switch (this.service.ordinal()) {
                case 0: {
                    this.loadModrinthInfo();
                    break;
                }
                case 1: {
                    this.loadGitHubInfo();
                }
            }
        }).start();
    }

    public void loadGitHubInfo() {
        try {
            JsonObject jsonObject;
            String url = String.format("https://api.github.com/repos/%s", this.id);
            JsonObject jsonObject2 = jsonObject = cache.containsKey(url) ? cache.get(url) : WebUtils.getJsonObject(url);
            if (this.title.isBlank()) {
                this.title = GsonHelper.getStringInJSON((String)"name", (JsonObject)jsonObject, (String)"");
            }
            if (this.description.isBlank()) {
                this.description = GsonHelper.getStringInJSON((String)"description", (JsonObject)jsonObject, (String)"");
            }
            cache.put(url, jsonObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadModrinthInfo() {
        try {
            JsonObject jsonObject;
            String url = String.format("https://api.modrinth.com/v2/project/%s", this.id);
            JsonObject jsonObject2 = jsonObject = cache.containsKey(url) ? cache.get(url) : WebUtils.getJsonObject(url);
            if (this.title.isBlank()) {
                this.title = GsonHelper.getStringInJSON((String)"title", (JsonObject)jsonObject, (String)"");
            }
            if (this.description.isBlank()) {
                this.description = GsonHelper.getStringInJSON((String)"description", (JsonObject)jsonObject, (String)"");
            }
            if (this.icon.isBlank()) {
                this.icon = GsonHelper.getStringInJSON((String)"icon_url", (JsonObject)jsonObject, (String)"");
            }
            cache.put(url, jsonObject);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static enum Service {
        MODRINTH("Modrinth"),
        GITHUB("GitHub"),
        INTERNET("Internet");

        public final String name;
        public final String iconChar;

        private Service(String name) {
            this(name, "\ud999");
        }

        private Service(String name, String iconChar) {
            this.name = name;
            this.iconChar = iconChar;
        }

        static Service getServiceByID(String id) {
            return switch (id) {
                case "modrinth" -> MODRINTH;
                case "github" -> GITHUB;
                default -> INTERNET;
            };
        }

        static String getServiceURL(Service service, String id) {
            return switch (service.ordinal()) {
                case 0 -> String.format("%sproject/%s", PepeLandHelper.config.getString("MODRINTH_URL", "https://modrinth.com/"), id);
                case 1 -> String.format("https://github.com/%s", id);
                default -> id;
            };
        }
    }
}

