/*
 * Decompiled with CFR 0.152.
 */
package ru.pplh.mod.utils;

import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import ru.kelcuprum.alinlib.AlinLib;
import ru.kelcuprum.alinlib.info.World;
import ru.pplh.mod.PepeLandHelper;
import ru.pplh.mod.api.components.project.Project;
import ru.pplh.mod.utils.TabHelper;

public class FollowManager {
    public static int[] coordinates;
    public static String name;
    public static String level;
    public static TabHelper.Worlds world;
    public static Project project;

    public static Coordinates getCurrentCoordinates() {
        if (project != null) {
            String[] coordinatesArgs = FollowManager.getStringProjectCoordinates(project).split(" ");
            int[] coordinatesProject = new int[coordinatesArgs.length];
            for (int i = 0; i < coordinatesArgs.length; ++i) {
                coordinatesProject[i] = !coordinatesArgs[i].isBlank() ? Integer.parseInt(coordinatesArgs[i]) : 0;
            }
            return new Coordinates(FollowManager.project.title, FollowManager.getWorldProjectWithoutWorld(project), TabHelper.getWorldByShortName(FollowManager.project.world), coordinatesProject);
        }
        if (coordinates != null) {
            return new Coordinates(name, level, world, coordinates);
        }
        return null;
    }

    public static boolean playerInCurrentWorld() {
        return (project != null || coordinates != null) && PepeLandHelper.playerInPPL() && TabHelper.getWorld() == world;
    }

    public static boolean playerInCurrentLevel() {
        return (project != null || coordinates != null) && PepeLandHelper.playerInPPL() && (project == null ? level : FollowManager.getWorldProject(project)).equals(World.getCodeName());
    }

    public static String getLevelName(String name) {
        return switch (name) {
            case "minecraft:overworld" -> AlinLib.localization.getLocalization("world.overworld");
            case "minecraft:the_nether" -> AlinLib.localization.getLocalization("world.nether");
            default -> AlinLib.localization.getLocalization("world.end");
        };
    }

    public static void setCoordinates(String name, TabHelper.Worlds world, String level, int x, int y) {
        coordinates = new int[]{x, y};
        FollowManager.name = name;
        FollowManager.world = world;
        FollowManager.level = level;
    }

    public static void setCoordinates(Project project) {
        FollowManager.project = project;
        name = project.title;
        world = TabHelper.getWorldByShortName(project.world);
        level = FollowManager.getWorldProject(project);
        coordinates = null;
    }

    public static void resetCoordinates() {
        coordinates = null;
        name = null;
        world = null;
        level = null;
        project = null;
    }

    public static float dist(int i, int j, int k, int l) {
        int m = k - i;
        int n = l - j;
        return class_3532.method_15355((float)(m * m + n * n));
    }

    @NotNull
    public static String getStringProjectCoordinates(Project project) {
        String coordinates = "";
        if (World.getCodeName().equals("minecraft:overworld") && project.coordinates$overworld != null && !project.coordinates$overworld.isEmpty()) {
            coordinates = project.coordinates$overworld;
        } else if (World.getCodeName().equals("minecraft:the_nether") && project.coordinates$nether != null && !project.coordinates$nether.isEmpty()) {
            coordinates = project.coordinates$nether;
        } else if (World.getCodeName().equals("minecraft:the_end") && project.coordinates$end != null && !project.coordinates$end.isEmpty()) {
            coordinates = project.coordinates$end;
        }
        if (coordinates.isEmpty()) {
            coordinates = FollowManager.getStringProjectCoordinatesWithoutWorld(project);
        }
        return coordinates.replaceAll("[^0-9 \\-.]", "");
    }

    @NotNull
    public static String getStringProjectCoordinatesWithoutWorld(Project project) {
        String coordinates = "";
        if (project.coordinates$overworld != null && !project.coordinates$overworld.isEmpty()) {
            coordinates = project.coordinates$overworld;
        } else if (project.coordinates$nether != null && !project.coordinates$nether.isEmpty()) {
            coordinates = project.coordinates$nether;
        } else if (project.coordinates$end != null && !project.coordinates$end.isEmpty()) {
            coordinates = project.coordinates$end;
        }
        return coordinates.replaceAll("[^0-9 \\-.]", "");
    }

    @NotNull
    public static String getWorldProjectWithoutWorld(Project project) {
        String coordinates = "";
        if (project.coordinates$overworld != null && !project.coordinates$overworld.isEmpty()) {
            coordinates = "minecraft:overworld";
        } else if (project.coordinates$nether != null && !project.coordinates$nether.isEmpty()) {
            coordinates = "minecraft:the_nether";
        } else if (project.coordinates$end != null && !project.coordinates$end.isEmpty()) {
            coordinates = "minecraft:the_end";
        }
        return coordinates;
    }

    @NotNull
    public static String getWorldProject(Project project) {
        String coordinates = "";
        if (project.coordinates$overworld != null && !project.coordinates$overworld.isEmpty() && World.getCodeName().equals("minecraft:overworld")) {
            coordinates = "minecraft:overworld";
        } else if (project.coordinates$nether != null && !project.coordinates$nether.isEmpty() && World.getCodeName().equals("minecraft:the_nether")) {
            coordinates = "minecraft:the_nether";
        } else if (project.coordinates$end != null && !project.coordinates$end.isEmpty() && World.getCodeName().equals("minecraft:the_end")) {
            coordinates = "minecraft:the_end";
        }
        if (coordinates.isEmpty()) {
            coordinates = FollowManager.getWorldProjectWithoutWorld(project);
        }
        return coordinates;
    }

    public static double getCord(int coordinate) {
        return (double)coordinate + (coordinate < 0 ? -0.5 : 0.5);
    }

    static {
        name = "";
    }

    public record Coordinates(String name, String level, TabHelper.Worlds world, int[] coordinates) {
        public String getStringCoordinates() {
            StringBuilder builder = new StringBuilder().append(this.coordinates()[0]);
            builder.append(" ").append(this.coordinates()[this.coordinates().length - 1]);
            return builder.toString();
        }

        public class_243 pos() {
            if (this.coordinates.length == 2) {
                return new class_243(FollowManager.getCord(this.coordinates[0]), AlinLib.MINECRAFT.field_1724.method_19538().field_1351, FollowManager.getCord(this.coordinates[1]));
            }
            return new class_243(FollowManager.getCord(this.coordinates[0]), FollowManager.getCord(this.coordinates[1]), FollowManager.getCord(this.coordinates[2]));
        }
    }
}

