/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.advancements.criteria;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.toukun.mymod.advancements.ModCriteriaTriggers;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;

public class DashTrigger
extends SimpleCriterionTrigger<DashTriggerInstance> {
    private static final String GREATER_KEY = "greater_than";
    private static final String LESS_KEY = "less_than";

    public Codec<DashTriggerInstance> codec() {
        return DashTriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, int dashCooldown) {
        this.trigger(player, triggerInstance -> triggerInstance.matches(dashCooldown));
    }

    public record DashTriggerInstance(Optional<ContextAwarePredicate> player, Optional<Integer> greaterThan, Optional<Integer> lessThan) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<DashTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.strictOptionalField((Codec)EntityPredicate.ADVANCEMENT_CODEC, (String)"player").forGetter(DashTriggerInstance::player), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)DashTrigger.GREATER_KEY).forGetter(DashTriggerInstance::greaterThan), (App)ExtraCodecs.strictOptionalField((Codec)ExtraCodecs.POSITIVE_INT, (String)DashTrigger.LESS_KEY).forGetter(DashTriggerInstance::lessThan)).apply((Applicative)instance, DashTriggerInstance::new));

        public static Criterion<DashTriggerInstance> dashed() {
            return ((DashTrigger)((Object)ModCriteriaTriggers.DASH_TRIGGER.get())).createCriterion((CriterionTriggerInstance)new DashTriggerInstance(Optional.empty(), Optional.empty(), Optional.empty()));
        }

        public static Criterion<DashTriggerInstance> cooldownLessThan(int lessThan) {
            return ((DashTrigger)((Object)ModCriteriaTriggers.DASH_TRIGGER.get())).createCriterion((CriterionTriggerInstance)new DashTriggerInstance(Optional.empty(), Optional.empty(), Optional.of(lessThan)));
        }

        public static Criterion<DashTriggerInstance> cooldownGreaterThan(int greaterThan) {
            return ((DashTrigger)((Object)ModCriteriaTriggers.DASH_TRIGGER.get())).createCriterion((CriterionTriggerInstance)new DashTriggerInstance(Optional.empty(), Optional.of(greaterThan), Optional.empty()));
        }

        public static Criterion<DashTriggerInstance> cooldownBetween(int greaterThan, int lessThan) {
            return ((DashTrigger)((Object)ModCriteriaTriggers.DASH_TRIGGER.get())).createCriterion((CriterionTriggerInstance)new DashTriggerInstance(Optional.empty(), Optional.of(greaterThan), Optional.of(lessThan)));
        }

        public boolean matches(int dashCooldown) {
            boolean greaterThanSet = this.greaterThan.isPresent();
            boolean lessThanSet = this.lessThan.isPresent();
            if (!greaterThanSet && !lessThanSet) {
                return true;
            }
            if (greaterThanSet && lessThanSet) {
                return dashCooldown > this.greaterThan.get() && dashCooldown < this.lessThan.get();
            }
            if (greaterThanSet) {
                return dashCooldown > this.greaterThan.get();
            }
            return dashCooldown < this.lessThan.get();
        }
    }
}

