/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.attachments.dash;

import com.toukun.mymod.enchantment.ModEnchantments;
import com.toukun.mymod.enchantment.custom.AgilityEnchantment;
import com.toukun.mymod.enchantment.custom.LeapEnchantment;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class DashArmorUtils {
    public static final int LIGHT_ARMOR_PENALTY = 2;
    public static final int HEAVY_ARMOR_PENALTY = 5;
    private static final double DASH_Y_VEL = 0.2;
    private static final String LEATHER = "leather";
    private static final String IRON = "iron";
    private static final String CHAINMAIL = "chainmail";
    private static final String NETHERITE_CHAINMAIL = "netherite_chainmail";
    private static final String GOLD = "gold";
    private static final String DIAMOND = "diamond";
    private static final String NETHERITE = "netherite";
    private static final String TURTLE = "turtle";

    public static int GetCooldownPenaltyByItem(ItemStack itemStack) {
        if (itemStack.isEmpty()) {
            return 0;
        }
        Item item = itemStack.getItem();
        if (item instanceof ArmorItem) {
            int level;
            int value;
            ArmorItem armorItem = (ArmorItem)item;
            switch (armorItem.getMaterial().getName()) {
                case "leather": 
                case "chainmail": 
                case "turtle": 
                case "netherite_chainmail": {
                    int n = 2;
                    break;
                }
                case "iron": 
                case "gold": 
                case "diamond": 
                case "netherite": {
                    int n = 5;
                    break;
                }
                default: {
                    int n = value = 0;
                }
            }
            if (LivingEntity.getEquipmentSlotForItem((ItemStack)itemStack) == EquipmentSlot.LEGS && itemStack.isEnchanted() && (level = itemStack.getEnchantmentLevel(ModEnchantments.AGILITY.get())) != 0) {
                value -= AgilityEnchantment.getDashReduction(level);
            }
            return value;
        }
        return 0;
    }

    public static double GetDashHeight(ServerPlayer player) {
        int level = EnchantmentHelper.getEnchantmentLevel((Enchantment)ModEnchantments.LEAP.get(), (LivingEntity)player);
        return level != 0 ? 0.2 + LeapEnchantment.getDashHeightBonus(level) : 0.2;
    }
}

