/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.attachments.dash;

import com.toukun.mymod.attachments.ModAttachments;
import com.toukun.mymod.attachments.dash.DashArmorUtils;
import com.toukun.mymod.network.packets.DashPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public class DashAttachmentHandler {
    private static final int DEFAULT_COOL_DOWN = 30;

    public static void Tick(ServerPlayer player) {
        int newValue;
        int dash = DashAttachmentHandler.GetDashCooldown(player);
        if (dash > 0 && (newValue = DashAttachmentHandler.SetDashCooldown(player, dash - 1)) == 0) {
            player.connection.send((CustomPacketPayload)new DashPacket(newValue));
        }
    }

    public static int GetDashCooldown(ServerPlayer player) {
        return (Integer)player.getData(ModAttachments.DASH);
    }

    public static int SetDashCooldown(ServerPlayer player, int value) {
        player.setData(ModAttachments.DASH, (Object)value);
        return value;
    }

    public static void ResetDashCooldown(ServerPlayer player) {
        int[] dashCooldown = new int[]{30};
        player.getArmorSlots().forEach(itemStack -> {
            dashCooldown[0] = dashCooldown[0] + DashArmorUtils.GetCooldownPenaltyByItem(itemStack);
        });
        player.setData(ModAttachments.DASH, (Object)dashCooldown[0]);
    }
}

