/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.attachments.hearth;

import com.toukun.mymod.attachments.ModAttachments;
import com.toukun.mymod.network.packets.HearthPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public class HearthAttachmentHandler {
    public static final int MAX_COOL_DOWN = 600;
    private static final int MIN_COOL_DOWN = 0;
    private static final int TICK_MIN = 0;
    private static final int TICK_MAX = 20;

    public static void Tick(ServerPlayer player) {
        int newCooldown;
        int cooldown = HearthAttachmentHandler.GetHearthCooldown(player);
        if (cooldown > 0 && (newCooldown = HearthAttachmentHandler.NumericTickLogic(player)) == 0) {
            player.connection.send((CustomPacketPayload)new HearthPacket(newCooldown));
        }
    }

    private static int NumericTickLogic(ServerPlayer player) {
        int cooldown = HearthAttachmentHandler.GetHearthCooldown(player);
        if (cooldown == 0) {
            return -1;
        }
        int ticks = HearthAttachmentHandler.SetHearthTicks(player, HearthAttachmentHandler.GetHearthTicks(player) + 1);
        if (ticks < 20) {
            return -1;
        }
        HearthAttachmentHandler.SetHearthTicks(player, 0);
        return HearthAttachmentHandler.SetHeartCooldown(player, cooldown - 1);
    }

    public static int GetHearthCooldown(ServerPlayer player) {
        return (Integer)player.getData(ModAttachments.HEARTH_SECONDS);
    }

    public static int SetHeartCooldown(ServerPlayer player, int value) {
        player.setData(ModAttachments.HEARTH_SECONDS, (Object)value);
        return value;
    }

    public static int GetHearthTicks(ServerPlayer player) {
        return (Integer)player.getData(ModAttachments.HEARTH_TICKS);
    }

    public static int SetHearthTicks(ServerPlayer player, int value) {
        player.setData(ModAttachments.HEARTH_TICKS, (Object)value);
        return value;
    }

    public static void ResetHearth(ServerPlayer player) {
        HearthAttachmentHandler.SetHeartCooldown(player, 600);
        HearthAttachmentHandler.SetHearthTicks(player, 0);
    }

    public static void ClearHearth(ServerPlayer player) {
        HearthAttachmentHandler.SetHeartCooldown(player, 0);
        HearthAttachmentHandler.SetHearthTicks(player, 0);
    }
}

