/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.block;

import com.toukun.mymod.block.custom.QuestBoardBlock;
import com.toukun.mymod.block.custom.WallSconceBlock;
import com.toukun.mymod.item.ModItems;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"toukun");
    public static final DeferredBlock<Block> SILVER_BLOCK = ModBlocks.registerBlock("silver_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).strength(6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SILVER_ORE = ModBlocks.registerBlock("silver_ore", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_ORE).strength(6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> RAW_SILVER_BLOCK = ModBlocks.registerBlock("raw_silver_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.RAW_IRON_BLOCK).strength(6.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> STONE_WALL_SCONCE = ModBlocks.registerBlock("stone_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).noCollission().instabreak().lightLevel(value -> 15).sound(SoundType.STONE), ParticleTypes.FLAME));
    public static final DeferredBlock<Block> SOUL_STONE_WALL_SCONCE = ModBlocks.registerBlock("soul_stone_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_WALL_TORCH).noCollission().instabreak().lightLevel(value -> 10).sound(SoundType.STONE), ParticleTypes.SOUL_FIRE_FLAME));
    public static final DeferredBlock<Block> COPPER_WALL_SCONCE = ModBlocks.registerBlock("copper_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).noCollission().instabreak().lightLevel(value -> 15).sound(SoundType.METAL), ParticleTypes.FLAME));
    public static final DeferredBlock<Block> SOUL_COPPER_WALL_SCONCE = ModBlocks.registerBlock("soul_copper_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_WALL_TORCH).noCollission().instabreak().lightLevel(value -> 10).sound(SoundType.METAL), ParticleTypes.SOUL_FIRE_FLAME));
    public static final DeferredBlock<Block> IRON_WALL_SCONCE = ModBlocks.registerBlock("iron_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).noCollission().instabreak().lightLevel(value -> 15).sound(SoundType.METAL), ParticleTypes.FLAME));
    public static final DeferredBlock<Block> SOUL_IRON_WALL_SCONCE = ModBlocks.registerBlock("soul_iron_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_WALL_TORCH).noCollission().instabreak().lightLevel(value -> 10).sound(SoundType.METAL), ParticleTypes.SOUL_FIRE_FLAME));
    public static final DeferredBlock<Block> GOLD_WALL_SCONCE = ModBlocks.registerBlock("gold_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).noCollission().instabreak().lightLevel(value -> 15).sound(SoundType.METAL), ParticleTypes.FLAME));
    public static final DeferredBlock<Block> SOUL_GOLD_WALL_SCONCE = ModBlocks.registerBlock("soul_gold_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_WALL_TORCH).noCollission().instabreak().lightLevel(value -> 10).sound(SoundType.METAL), ParticleTypes.SOUL_FIRE_FLAME));
    public static final DeferredBlock<Block> SILVER_WALL_SCONCE = ModBlocks.registerBlock("silver_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WALL_TORCH).noCollission().instabreak().lightLevel(value -> 15).sound(SoundType.METAL), ParticleTypes.FLAME));
    public static final DeferredBlock<Block> SOUL_SILVER_WALL_SCONCE = ModBlocks.registerBlock("soul_silver_wall_sconce", () -> new WallSconceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SOUL_WALL_TORCH).noCollission().instabreak().lightLevel(value -> 10).sound(SoundType.METAL), ParticleTypes.SOUL_FIRE_FLAME));
    public static final DeferredBlock<Block> QUEST_BOARD = ModBlocks.registerBlock("quest_board", () -> new QuestBoardBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRAFTING_TABLE).strength(2.0f).sound(SoundType.WOOD).noOcclusion()));
    public static final DeferredBlock<Block> PORTAL_BLOCK = ModBlocks.registerBlock("portal_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OBSIDIAN).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).lightLevel(value -> 10)));
    public static final DeferredBlock<Block> CHISELED_SMOOTH_STONE_BLOCK = ModBlocks.registerBlock("chiseled_smooth_stone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).requiresCorrectToolForDrops().strength(1.5f, 6.0f)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock registeredBlock = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, registeredBlock);
        return registeredBlock;
    }

    private static <T extends Block> DeferredItem<Item> registerBlockItem(String name, DeferredBlock<T> block) {
        return ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

