/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.block.custom;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallSconceBlock
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    private static final Map<Direction, VoxelShape> AABBS = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.box((double)5.0, (double)5.0, (double)13.0, (double)11.0, (double)9.0, (double)16.0), (Object)Direction.SOUTH, (Object)Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)9.0, (double)3.0), (Object)Direction.WEST, (Object)Block.box((double)13.0, (double)5.0, (double)5.0, (double)16.0, (double)9.0, (double)11.0), (Object)Direction.EAST, (Object)Block.box((double)0.0, (double)5.0, (double)5.0, (double)3.0, (double)9.0, (double)11.0)));
    protected final SimpleParticleType flameParticle;

    public WallSconceBlock(BlockBehaviour.Properties properties, SimpleParticleType flameParticle) {
        super(properties);
        this.flameParticle = flameParticle;
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    public static VoxelShape getShape(BlockState blockState) {
        return AABBS.get(blockState.getValue((Property)FACING));
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return WallSconceBlock.getShape(blockState);
    }

    public BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        return direction.getOpposite() == blockState.getValue((Property)FACING) && !blockState.canSurvive((LevelReader)levelAccessor, blockPos) ? Blocks.AIR.defaultBlockState() : blockState;
    }

    public boolean canSurvive(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        Direction direction = (Direction)blockState.getValue((Property)FACING);
        BlockPos blockpos = blockPos.relative(direction.getOpposite());
        BlockState blockstate = levelReader.getBlockState(blockpos);
        return blockstate.isFaceSturdy((BlockGetter)levelReader, blockpos, direction);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Direction[] adirection;
        BlockState blockstate = this.defaultBlockState();
        Level levelreader = blockPlaceContext.getLevel();
        BlockPos blockpos = blockPlaceContext.getClickedPos();
        for (Direction direction : adirection = blockPlaceContext.getNearestLookingDirections()) {
            Direction direction1;
            if (!direction.getAxis().isHorizontal() || !(blockstate = (BlockState)blockstate.setValue((Property)FACING, (Comparable)(direction1 = direction.getOpposite()))).canSurvive((LevelReader)levelreader, blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        Direction direction = (Direction)blockState.getValue((Property)FACING);
        double d0 = (double)blockPos.getX() + 0.5;
        double d1 = (double)blockPos.getY() + 0.5;
        double d2 = (double)blockPos.getZ() + 0.5;
        Direction opposite = direction.getOpposite();
        level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + 0.42 * (double)opposite.getStepX(), d1 + 0.22, d2 + 0.42 * (double)opposite.getStepZ(), 0.0, 0.0, 0.0);
        level.addParticle((ParticleOptions)this.flameParticle, d0 + 0.42 * (double)opposite.getStepX(), d1 + 0.22, d2 + 0.42 * (double)opposite.getStepZ(), 0.0, 0.0, 0.0);
    }

    public BlockState rotate(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)blockState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState blockState, Mirror mirror) {
        return blockState.rotate(mirror.getRotation((Direction)blockState.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> blockBlockStateBuilder) {
        blockBlockStateBuilder.add(new Property[]{FACING});
    }
}

