/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.block.entity;

import com.toukun.mymod.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Nameable;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class QuestBoardBlockEntity
extends BlockEntity
implements Nameable {
    public static final String ENTITY_NAME = "entity.toukun.quest_board";
    private Component name;

    public QuestBoardBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(ModBlockEntities.QUEST_BOARD.get(), blockPos, blockState);
    }

    protected void saveAdditional(CompoundTag compoundTag) {
        super.saveAdditional(compoundTag);
        if (this.hasCustomName()) {
            compoundTag.putString("CustomName", Component.Serializer.toJson((Component)this.name));
        }
    }

    public void load(CompoundTag compoundTag) {
        super.load(compoundTag);
        if (compoundTag.contains("CustomName", 8)) {
            this.name = Component.Serializer.fromJson((String)compoundTag.getString("CustomName"));
        }
    }

    public Component getName() {
        return this.name != null ? this.name : Component.translatable((String)ENTITY_NAME);
    }

    @Nullable
    public Component getCustomName() {
        return this.name;
    }

    public void setCustomName(@Nullable Component customName) {
        this.name = customName;
    }
}

