/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.dash;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientDashData {
    private static int dashCooldown;
    private static int prevCooldown;
    private static int impatient;
    private static boolean noCooldown;

    public static void setCooldown(int coolDown) {
        if (coolDown > dashCooldown) {
            prevCooldown = coolDown;
        }
        boolean bl = noCooldown = (dashCooldown = coolDown) == 0;
        if (noCooldown) {
            impatient = 0;
        }
    }

    public static void tick() {
        if (dashCooldown > 1) {
            --dashCooldown;
        }
        if (impatient > 0) {
            --impatient;
        }
    }

    public static boolean dashReady() {
        return noCooldown;
    }

    public static int getDashCooldown() {
        return dashCooldown;
    }

    public static boolean isImpatient() {
        return impatient > 0;
    }

    public static void setImpatient(int value) {
        impatient = value;
    }

    public static float getRed() {
        return noCooldown ? 0.0f : 1.0f;
    }

    public static float getGreen() {
        return ClientDashData.isImpatient() ? 0.0f : 1.0f;
    }

    public static float getBlue() {
        return noCooldown || ClientDashData.isImpatient() ? 0.0f : 1.0f;
    }

    public static float getAlpha() {
        if (noCooldown) {
            return 1.0f;
        }
        return (float)(prevCooldown - dashCooldown) / (float)prevCooldown;
    }

    static {
        impatient = 0;
        noCooldown = false;
    }
}

