/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.dash;

import com.mojang.blaze3d.systems.RenderSystem;
import com.toukun.mymod.client.dash.ClientDashData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class DashHUDOverlay {
    private static final ResourceLocation SMALL_DASH = new ResourceLocation("toukun", "textures/gui/small_dash.png");
    private static final ResourceLocation SMALL_DASH_EMPTY = new ResourceLocation("toukun", "textures/gui/small_dash_empty.png");
    public static final IGuiOverlay HUD_DASH = (guid, poseStack, partialTick, width, height) -> {
        Minecraft minecraft = guid.getMinecraft();
        if (minecraft.options.hideGui || !guid.shouldDrawSurvivalElements() || minecraft.player != null && minecraft.player.isSleeping()) {
            return;
        }
        int x = width / 2 - 8;
        int y = height - 51;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.setShaderColor((float)ClientDashData.getRed(), (float)ClientDashData.getGreen(), (float)ClientDashData.getBlue(), (float)ClientDashData.getAlpha());
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SMALL_DASH);
        poseStack.blit(SMALL_DASH, x, y, 0.0f, 0.0f, 15, 15, 15, 15);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)SMALL_DASH_EMPTY);
        poseStack.blit(SMALL_DASH_EMPTY, x, y, 0.0f, 0.0f, 15, 15, 15, 15);
        RenderSystem.disableBlend();
    };
}

