/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.gui;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class CompassHUDOverlay {
    public static final IGuiOverlay HUD_COMPASS = (guid, poseStack, partialTick, width, height) -> {
        Minecraft minecraft = guid.getMinecraft();
        if (minecraft.options.hideGui || minecraft.player != null && minecraft.player.isSleeping()) {
            return;
        }
        Entity entity = minecraft.getCameraEntity();
        if (entity == null) {
            return;
        }
        BlockPos currentPos = entity.blockPosition();
        String directionName = entity.getDirection().getName();
        String directionString = directionName.substring(0, 1).toUpperCase() + directionName.substring(1);
        String position = String.format("(%d, %d, %d)", currentPos.getX(), currentPos.getY(), currentPos.getZ());
        int startWidth = width / 2 + 93;
        poseStack.drawString(minecraft.font, directionString, startWidth, height - 20, Color.WHITE.getRGB());
        poseStack.drawString(minecraft.font, position, startWidth, height - 10, Color.WHITE.getRGB());
    };
}

