/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.toukun.mymod.config.Config;
import com.toukun.mymod.item.classes.IUseTimeItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class SwingTimerHUDOverlay {
    private static final int BAR_TEX_SIZE_X = 67;
    private static final int BAR_TEX_SIZE_Y = 5;
    private static final int BORDER_TEX_SIZE_X = 73;
    private static final int BORDER_TEX_SIZE_Y = 19;
    private static final int TARGET_TEX_SIZE = 15;
    private static final ResourceLocation BAR_BORDER = new ResourceLocation("toukun", "textures/gui/swing_timer_empty.png");
    private static final ResourceLocation BAR = new ResourceLocation("toukun", "textures/gui/swing_timer_bar.png");
    private static final ResourceLocation TARGET = new ResourceLocation("toukun", "textures/gui/swing_timer_target.png");
    public static final IGuiOverlay HUD_SWING_TIMER = (guid, poseStack, partialTick, width, height) -> {
        LivingEntity livingEntity;
        Entity patt2964$temp;
        if (!((Boolean)Config.SHOW_SWING_TIMER.get()).booleanValue()) {
            return;
        }
        Minecraft minecraft = guid.getMinecraft();
        if (minecraft.options.hideGui || !guid.shouldDrawSurvivalElements()) {
            return;
        }
        LocalPlayer player = minecraft.player;
        if (player == null) {
            return;
        }
        if (player.isSleeping()) {
            return;
        }
        int xStart = width / 2 - 37;
        int yStart = height - 89;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BAR_BORDER);
        poseStack.blit(BAR_BORDER, xStart, yStart, 0.0f, 0.0f, 73, 19, 73, 19);
        float percentage = player.getAttackStrengthScale(0.0f);
        if (player.isUsingItem()) {
            ItemStack itemStack = player.getItemInHand(player.getUsedItemHand());
            Item patt2657$temp = itemStack.getItem();
            if (patt2657$temp instanceof IUseTimeItem) {
                IUseTimeItem iUseTimeItem = (IUseTimeItem)patt2657$temp;
                int usedFor = player.getTicksUsingItem();
                percentage = iUseTimeItem.getUseTimePercentage(itemStack, usedFor);
            }
        } else if (percentage == 1.0f && (patt2964$temp = minecraft.crosshairPickEntity) instanceof LivingEntity && (livingEntity = (LivingEntity)patt2964$temp).isAlive()) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TARGET);
            poseStack.blit(TARGET, width / 2 - 8, yStart + 2, 0.0f, 0.0f, 15, 15, 15, 15);
        }
        if (percentage == 1.0f) {
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)0.5f);
        } else {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BAR);
        poseStack.blit(BAR, xStart + 3, yStart + 7, 0.0f, 0.0f, Math.round(67.0f * percentage), 5, 67, 5);
        RenderSystem.disableBlend();
    };
}

