/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.hearth;

import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientHearthData {
    private static int hearthCooldown;
    private static int hearthTick;
    private static int impatient;
    private static boolean noCooldown;

    public static void setCooldown(int cooldown) {
        hearthCooldown = cooldown;
        boolean bl = noCooldown = hearthCooldown == 0;
        if (noCooldown) {
            impatient = 0;
        }
        if (impatient > 0) {
            --impatient;
        }
    }

    public static void tick() {
        if (hearthCooldown > 1 && ++hearthTick == 20) {
            hearthTick = 0;
            --hearthCooldown;
        }
        if (impatient > 0) {
            --impatient;
        }
    }

    public static boolean hearthReady() {
        return noCooldown;
    }

    public static int getHearthCooldown() {
        return hearthCooldown;
    }

    public static boolean isImpatient() {
        return impatient > 0;
    }

    public static void setImpatient(int value) {
        impatient = value;
    }

    public static float getRed() {
        return noCooldown ? 0.0f : 1.0f;
    }

    public static float getGreen() {
        return ClientHearthData.isImpatient() ? 0.0f : 1.0f;
    }

    public static float getBlue() {
        return noCooldown || ClientHearthData.isImpatient() ? 0.0f : 1.0f;
    }

    public static float getPercentCooldownRemaining() {
        return (float)(600 - hearthCooldown) / 600.0f;
    }

    static {
        hearthTick = 0;
        impatient = 0;
        noCooldown = false;
    }
}

