/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.hearth;

import com.mojang.blaze3d.systems.RenderSystem;
import com.toukun.mymod.client.hearth.ClientHearthData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class HearthHUDOverlay {
    private static final ResourceLocation HEARTH_BORDER = new ResourceLocation("toukun", "textures/gui/hearth_border.png");
    private static final ResourceLocation HEARTH_BAR = new ResourceLocation("toukun", "textures/gui/hearth_bar.png");
    private static final ResourceLocation HEARTH_ICON = new ResourceLocation("toukun", "textures/gui/hearth_icon.png");
    public static final IGuiOverlay HUD_HEARTH = (guid, poseStack, partialTick, width, height) -> {
        Minecraft minecraft = guid.getMinecraft();
        if (minecraft.options.hideGui || !guid.shouldDrawSurvivalElements() || minecraft.player != null && minecraft.player.isSleeping()) {
            return;
        }
        int startWidth = width / 2 - 152;
        int startHeight = height - 24;
        int iconStartWidth = startWidth + 5;
        int iconStartHeight = startHeight + 3;
        int cooldown = ClientHearthData.getHearthCooldown();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEARTH_ICON);
        poseStack.blit(HEARTH_ICON, iconStartWidth, iconStartHeight, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)ClientHearthData.getRed(), (float)ClientHearthData.getGreen(), (float)ClientHearthData.getBlue(), (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEARTH_BORDER);
        poseStack.blit(HEARTH_BORDER, startWidth, startHeight, 0.0f, 0.0f, 26, 24, 26, 24);
        if (cooldown != 0) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
            int displayHeight = Math.round(16.0f * ClientHearthData.getPercentCooldownRemaining());
            int difference = 16 - displayHeight;
            int barStartHeight = iconStartHeight + displayHeight;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEARTH_BAR);
            poseStack.blit(HEARTH_BAR, iconStartWidth, barStartHeight, 0.0f, 0.0f, 16, difference, 16, 16);
        }
        RenderSystem.disableBlend();
    };
}

