/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.party;

import com.toukun.mymod.client.party.PartyToast;
import com.toukun.mymod.network.packets.PartyEndPacket;
import com.toukun.mymod.network.packets.PartyInvitePacket;
import com.toukun.mymod.network.packets.PartyTeleportPacket;
import com.toukun.mymod.network.packets.PartyUpdatePacket;
import com.toukun.mymod.party.network.PartyPlayerData;
import com.toukun.mymod.party.network.PartyUpdateData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class ClientPartyData {
    private static final Map<UUID, PartyPlayerData> memberMap = new HashMap<UUID, PartyPlayerData>();
    private static final Map<UUID, PartyInvitePacket> inviteMap = new HashMap<UUID, PartyInvitePacket>();
    private static final Set<UUID> ignoredInviteSet = new HashSet<UUID>();
    @Nullable
    private static UUID leaderId;
    @Nullable
    private static String partyName;
    private static int teleportCooldown;

    public static void reset() {
        leaderId = null;
        partyName = null;
        memberMap.clear();
        inviteMap.clear();
        ignoredInviteSet.clear();
    }

    private static Optional<String> getLeaderName() {
        if (memberMap.isEmpty()) {
            return Optional.empty();
        }
        Optional<PartyPlayerData> leader = Optional.ofNullable(memberMap.get(leaderId));
        return leader.map(PartyPlayerData::name);
    }

    private static void sendToast(Minecraft instance, PartyToast.PartyToastId id, String name) {
        PartyToast.add(instance.getToasts(), id, name);
    }

    private static void initPartyData(Minecraft instance, PartyUpdateData data) {
        leaderId = data.getLeaderId();
        partyName = data.getPartyName();
        if (data.isForNewMember()) {
            ClientPartyData.sendToast(instance, PartyToast.PartyToastId.SELF_JOINED, partyName);
        }
        data.getMemberDataList().forEach(memberData -> memberMap.put(memberData.id(), (PartyPlayerData)memberData));
        inviteMap.clear();
    }

    private static void changeLeader(Minecraft instance, UUID newLeaderId) {
        leaderId = newLeaderId;
        if (instance.isLocalPlayer(newLeaderId)) {
            LocalPlayer player = instance.player;
            if (player != null) {
                ClientPartyData.sendToast(instance, PartyToast.PartyToastId.LEADER_CHANGED, player.getName().getString());
            }
            return;
        }
        ClientPartyData.getLeaderName().ifPresent(name -> ClientPartyData.sendToast(instance, PartyToast.PartyToastId.LEADER_CHANGED, name));
    }

    private static void changePartyName(Minecraft instance, String newPartyName) {
        partyName = newPartyName;
        ClientPartyData.sendToast(instance, PartyToast.PartyToastId.NAME_CHANGED, newPartyName);
    }

    private static void removeMember(Minecraft instance, UUID removedMember) {
        if (instance.isLocalPlayer(removedMember)) {
            ClientPartyData.receiveEndPacket(new PartyEndPacket(true, false));
            return;
        }
        if (!memberMap.containsKey(removedMember)) {
            return;
        }
        PartyPlayerData member = memberMap.remove(removedMember);
        if (member != null) {
            ClientPartyData.sendToast(instance, PartyToast.PartyToastId.MEMBER_LEFT, member.name());
        }
    }

    private static void updateMembers(Minecraft instance, List<PartyPlayerData> updateList) {
        updateList.forEach(partyPlayerData -> {
            UUID id = partyPlayerData.id();
            if (!memberMap.containsKey(id)) {
                ClientPartyData.sendToast(instance, PartyToast.PartyToastId.MEMBER_JOINED, partyPlayerData.name());
            }
            memberMap.put(id, (PartyPlayerData)partyPlayerData);
        });
    }

    public static void receiveEndPacket(PartyEndPacket packet) {
        Minecraft instance = Minecraft.getInstance();
        if (packet.wasDisband() && packet.wasRemoved()) {
            ClientPartyData.reset();
            return;
        }
        if (packet.wasDisband()) {
            ClientPartyData.sendToast(instance, PartyToast.PartyToastId.PARTY_DISBAND, "");
        }
        if (packet.wasRemoved()) {
            ClientPartyData.sendToast(instance, PartyToast.PartyToastId.REMOVED, partyName);
        }
        ClientPartyData.reset();
    }

    public static void receiveUpdatePacket(PartyUpdatePacket packet) {
        List<PartyPlayerData> updateList;
        UUID removed;
        String dataName;
        Minecraft instance = Minecraft.getInstance();
        PartyUpdateData data = packet.data();
        if (ClientPartyData.isEmpty()) {
            ClientPartyData.initPartyData(instance, data);
            return;
        }
        UUID dataLeader = data.getLeaderId();
        if (!dataLeader.equals(leaderId)) {
            ClientPartyData.changeLeader(instance, dataLeader);
        }
        if (!(dataName = data.getPartyName()).equals(partyName)) {
            ClientPartyData.changePartyName(instance, dataName);
        }
        if ((removed = data.getRemovedPlayer()) != null) {
            ClientPartyData.removeMember(instance, removed);
        }
        if (!(updateList = data.getMemberDataList()).isEmpty()) {
            ClientPartyData.updateMembers(instance, updateList);
        }
    }

    public static void receiveInvitePacket(PartyInvitePacket packet) {
        if (!ClientPartyData.isEmpty()) {
            return;
        }
        UUID partyId = packet.partyId();
        boolean haveInvite = inviteMap.containsKey(partyId);
        if (haveInvite && !packet.status()) {
            inviteMap.remove(packet.partyId());
            return;
        }
        if (haveInvite) {
            return;
        }
        inviteMap.put(packet.partyId(), packet);
        if (!ignoredInviteSet.contains(partyId)) {
            ClientPartyData.sendToast(Minecraft.getInstance(), PartyToast.PartyToastId.INVITED, packet.partyName());
        }
    }

    public static void acceptInvite(UUID partyId) {
        if (!inviteMap.containsKey(partyId)) {
            return;
        }
        PartyInvitePacket invite = inviteMap.get(partyId);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PartyInvitePacket(invite.partyName(), partyId, true)});
    }

    public static void ignoreInvite(UUID partyId) {
        if (!inviteMap.containsKey(partyId)) {
            return;
        }
        inviteMap.remove(partyId);
        ignoredInviteSet.add(partyId);
    }

    public static void promoteMember(UUID memberId) {
        if (ClientPartyData.isEmpty()) {
            return;
        }
        if (memberId.equals(leaderId)) {
            return;
        }
        PartyUpdateData data = new PartyUpdateData(memberId, partyName == null ? "" : partyName, false);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PartyUpdatePacket(data)});
    }

    public static void kickMember(UUID memberId) {
        if (ClientPartyData.isEmpty()) {
            return;
        }
        PartyUpdateData data = new PartyUpdateData(leaderId, partyName == null ? "" : partyName, false);
        data.setRemovedPlayer(memberId);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PartyUpdatePacket(data)});
    }

    public static void changeName(String newName) {
        if (ClientPartyData.isEmpty()) {
            return;
        }
        PartyUpdateData data = new PartyUpdateData(leaderId, newName, false);
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PartyUpdatePacket(data)});
    }

    public static void receiveTeleportPacket(PartyTeleportPacket data) {
        teleportCooldown = data.cooldown();
    }

    public static void tick() {
        if (teleportCooldown > 1) {
            --teleportCooldown;
        }
    }

    public static void teleportToMember(UUID targetId) {
        if (ClientPartyData.isEmpty()) {
            return;
        }
        if (!ClientPartyData.canTeleport()) {
            return;
        }
        if (!memberMap.containsKey(targetId)) {
            return;
        }
        if (!memberMap.get(targetId).online()) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player != null && minecraft.player.getUUID().equals(targetId)) {
            return;
        }
        PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new PartyTeleportPacket(0, targetId)});
    }

    public static void iterateOverMembers(BiConsumer<PartyPlayerData, Integer> runnable) {
        Objects.requireNonNull(runnable);
        int i = 0;
        for (PartyPlayerData member : memberMap.values()) {
            runnable.accept(member, i);
            ++i;
        }
    }

    public static void iterateOverInvites(BiConsumer<PartyInvitePacket, Integer> runnable) {
        Objects.requireNonNull(runnable);
        int i = 0;
        for (PartyInvitePacket invite : inviteMap.values()) {
            runnable.accept(invite, i);
            ++i;
        }
    }

    @Nullable
    public static PartyPlayerData getMemberData(UUID memberId) {
        return memberMap.get(memberId);
    }

    public static List<PartyPlayerData> getPlayerDataList() {
        return new ArrayList<PartyPlayerData>(memberMap.values());
    }

    public static boolean isEmpty() {
        return leaderId == null || partyName == null;
    }

    public static Component getPartyName() {
        return Component.nullToEmpty((String)partyName);
    }

    @Nullable
    public static UUID getLeaderId() {
        return leaderId;
    }

    public static int getInviteCount() {
        return inviteMap.size();
    }

    public static int getMemberCount() {
        return memberMap.size();
    }

    public static boolean canTeleport() {
        return teleportCooldown == 0;
    }

    public static int getTeleportCooldown() {
        return teleportCooldown;
    }

    static {
        teleportCooldown = 0;
    }
}

