/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.party;

import com.mojang.blaze3d.systems.RenderSystem;
import com.toukun.mymod.client.party.ClientPartyData;
import com.toukun.mymod.party.network.PartyPlayerData;
import java.awt.Color;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.gui.overlay.IGuiOverlay;

@OnlyIn(value=Dist.CLIENT)
public class PartyHUDOverlay {
    private static final ResourceLocation STATUS_ICONS = new ResourceLocation("toukun", "textures/gui/sprites/hud/party/status.png");
    private static final ResourceLocation HEART_ICON = new ResourceLocation("textures/gui/sprites/hud/heart/full.png");
    private static final int ICON_DIMENSION = 12;
    private static final int STATUS_DIMENSION = 24;
    public static final IGuiOverlay HUD_PARTY = (guid, poseStack, partialTick, width, height) -> {
        Minecraft minecraft = guid.getMinecraft();
        if (minecraft.options.hideGui || !guid.shouldDrawSurvivalElements() || minecraft.player != null && minecraft.player.isSleeping()) {
            return;
        }
        if (ClientPartyData.isEmpty()) {
            return;
        }
        UUID leaderId = ClientPartyData.getLeaderId();
        List<PartyPlayerData> memberList = ClientPartyData.getPlayerDataList();
        if (memberList.isEmpty()) {
            return;
        }
        Font font = minecraft.font;
        int x = 4;
        int y = 4;
        poseStack.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.drawString(font, ClientPartyData.getPartyName(), x, y, Color.WHITE.getRGB(), false);
        y += 10;
        int i = 0;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionColorTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        while (i < memberList.size()) {
            PartyPlayerData member = memberList.get(i);
            if (minecraft.isLocalPlayer(member.id())) {
                ++i;
                continue;
            }
            PartyHUDOverlay.renderPlayer(poseStack, font, member, leaderId, x, y);
            ++i;
            y += 10;
        }
        RenderSystem.disableBlend();
    };

    private static void renderPlayer(GuiGraphics poseStack, Font font, PartyPlayerData member, UUID leaderId, int x, int y) {
        boolean online = member.online();
        boolean leader = member.id().equals(leaderId);
        int statusX = 0;
        int statusY = 0;
        int textColor = Color.GRAY.getRGB();
        if (online) {
            textColor = Color.WHITE.getRGB();
            statusX += 12;
        }
        if (leader) {
            statusY += 12;
        }
        int textX = x + 14;
        int textY = y + 3;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)STATUS_ICONS);
        poseStack.blit(STATUS_ICONS, x, y, (float)statusX, (float)statusY, 12, 12, 24, 24);
        int textWidth = poseStack.drawString(font, member.name(), textX, textY, textColor, false);
        if (online) {
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)HEART_ICON);
            poseStack.blit(HEART_ICON, textWidth, textY - 1, 0.0f, 0.0f, 9, 9, 9, 9);
            poseStack.drawString(font, String.format("%d", Math.round(member.health())), textWidth + 10, textY, textColor, false);
        }
    }
}

