/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.party;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PartyToast
implements Toast {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("toukun", "toast/party");
    private static final ResourceLocation INVITE = new ResourceLocation("toukun", "toast/invite");
    private static final ResourceLocation JOINED = new ResourceLocation("toukun", "toast/member_joined");
    private static final ResourceLocation LEAVE = new ResourceLocation("toukun", "toast/member_left");
    private static final ResourceLocation PROMOTED = new ResourceLocation("toukun", "toast/member_promoted");
    private static final long DEFAULT_DISPLAY_TIME = 3000L;
    private static final int ICON_DIMENSIONS = 20;
    private final PartyToastId id;
    private String name;
    private boolean changed;
    private long lastChanged;

    public PartyToast(PartyToastId id, String name) {
        this.id = id;
        this.name = name;
    }

    public static void add(ToastComponent toastComponent, PartyToastId id, String displayName) {
        PartyToast toast = (PartyToast)toastComponent.getToast(PartyToast.class, (Object)id);
        if (toast == null) {
            toastComponent.addToast((Toast)new PartyToast(id, displayName));
        } else {
            toast.reset(displayName);
        }
    }

    private Component getTitle() {
        return Component.translatable((String)("toast.party." + this.id.translationKey + ".title"));
    }

    private Component getMessage() {
        return Component.translatable((String)("toast.party." + this.id.translationKey + ".message"), (Object[])new Object[]{this.name});
    }

    public void reset(String name) {
        this.name = name;
        this.changed = true;
    }

    public Toast.Visibility render(GuiGraphics guiGraphics, ToastComponent toastComponent, long timeSinceLastVisible) {
        if (this.changed) {
            this.lastChanged = timeSinceLastVisible;
            this.changed = false;
        }
        guiGraphics.blitSprite(BACKGROUND, 0, 0, this.width(), this.height());
        ResourceLocation icon = this.id.getIcon();
        guiGraphics.blitSprite(icon, 6, 6, 20, 20);
        Font font = toastComponent.getMinecraft().font;
        guiGraphics.drawString(font, this.getTitle(), 28, 7, -256, false);
        guiGraphics.drawString(font, this.getMessage(), 32, 17, -256, false);
        double displayTime = 3000.0 * toastComponent.getNotificationDisplayTimeMultiplier();
        long displayedFor = timeSinceLastVisible - this.lastChanged;
        return (double)displayedFor < displayTime ? Toast.Visibility.SHOW : Toast.Visibility.HIDE;
    }

    public PartyToastId getToken() {
        return this.id;
    }

    @OnlyIn(value=Dist.CLIENT)
    public record PartyToastId(int id, String translationKey) {
        public static final PartyToastId INVITED = new PartyToastId(1, "received_invite");
        public static final PartyToastId MEMBER_JOINED = new PartyToastId(2, "joined");
        public static final PartyToastId MEMBER_LEFT = new PartyToastId(3, "left");
        public static final PartyToastId LEADER_CHANGED = new PartyToastId(4, "promoted");
        public static final PartyToastId PARTY_DISBAND = new PartyToastId(5, "disbanded");
        public static final PartyToastId REMOVED = new PartyToastId(6, "removed");
        public static final PartyToastId PLAYER_INVITED = new PartyToastId(7, "invited");
        public static final PartyToastId NAME_CHANGED = new PartyToastId(8, "renamed");
        public static final PartyToastId SELF_JOINED = new PartyToastId(9, "self_joined");

        public ResourceLocation getIcon() {
            return switch (this.id()) {
                default -> INVITE;
                case 2, 7, 9 -> JOINED;
                case 3, 5, 6 -> LEAVE;
                case 4, 8 -> PROMOTED;
            };
        }
    }
}

