/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.sizedBundles;

import com.toukun.mymod.item.classes.SizedBundleTooltip;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSizedBundleTooltip
implements ClientTooltipComponent {
    private static final ResourceLocation BACKGROUND_SPRITE = new ResourceLocation("container/bundle/background");
    private static final int MARGIN_Y = 4;
    private static final int BORDER_WIDTH = 1;
    private static final int SLOT_SIZE_X = 18;
    private static final int SLOT_SIZE_Y = 20;
    private final NonNullList<ItemStack> items;
    private final int weight;
    private final int maxWeight;

    public ClientSizedBundleTooltip(SizedBundleTooltip tooltip) {
        this.items = tooltip.items();
        this.weight = tooltip.weight();
        this.maxWeight = tooltip.maxWeight();
    }

    private int gridSizeX() {
        return Math.max(2, (int)Math.ceil(Math.sqrt((double)this.items.size() + 1.0)));
    }

    private int gridSizeY() {
        return (int)Math.ceil(((double)this.items.size() + 1.0) / (double)this.gridSizeX());
    }

    public int getHeight() {
        return this.gridSizeY() * 20 + 2 + 4;
    }

    public int getWidth(Font p_169901_) {
        return this.gridSizeX() * 18 + 2;
    }

    private int backgroundWidth() {
        return this.gridSizeX() * 18 + 2;
    }

    private int backgroundHeight() {
        return this.gridSizeY() * 20 + 2;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        int gridSizeX = this.gridSizeX();
        int gridSizeY = this.gridSizeY();
        guiGraphics.blitSprite(BACKGROUND_SPRITE, x, y, this.backgroundWidth(), this.backgroundHeight());
        boolean overWeight = this.weight >= this.maxWeight;
        int slot = 0;
        for (int yIterable = 0; yIterable < gridSizeY; ++yIterable) {
            for (int xIterable = 0; xIterable < gridSizeX; ++xIterable) {
                int xStart = x + xIterable * 18 + 1;
                int ySTart = y + yIterable * 20 + 1;
                this.renderSlot(xStart, ySTart, slot++, overWeight, guiGraphics, font);
            }
        }
    }

    private void renderSlot(int x, int y, int slot, boolean overWeight, GuiGraphics guiGraphics, Font font) {
        if (slot >= this.items.size()) {
            this.blit(guiGraphics, x, y, overWeight ? Texture.BLOCKED_SLOT : Texture.SLOT);
        } else {
            ItemStack itemstack = (ItemStack)this.items.get(slot);
            this.blit(guiGraphics, x, y, Texture.SLOT);
            guiGraphics.renderItem(itemstack, x + 1, y + 1, slot);
            guiGraphics.renderItemDecorations(font, itemstack, x + 1, y + 1);
            if (slot == 0) {
                AbstractContainerScreen.renderSlotHighlight((GuiGraphics)guiGraphics, (int)(x + 1), (int)(y + 1), (int)0);
            }
        }
    }

    private void blit(GuiGraphics guiGraphics, int x, int y, Texture texture) {
        guiGraphics.blitSprite(texture.sprite, x, y, texture.w, texture.h);
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum Texture {
        BLOCKED_SLOT(new ResourceLocation("container/bundle/blocked_slot"), 18, 20),
        SLOT(new ResourceLocation("container/bundle/slot"), 18, 20);

        public final ResourceLocation sprite;
        public final int w;
        public final int h;

        private Texture(ResourceLocation pSprite, int pW, int pH) {
            this.sprite = pSprite;
            this.w = pW;
            this.h = pH;
        }
    }
}

