/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.utility.rendering;

import com.mojang.blaze3d.systems.RenderSystem;
import com.toukun.mymod.client.utility.rendering.ButtonSizes;
import com.toukun.mymod.client.utility.rendering.ButtonTypes;
import com.toukun.mymod.client.utility.rendering.TextRenderer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ButtonRenderer {
    public static final int BUTTON_HEIGHT = 16;
    private static final ResourceLocation DEFAULT_16 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_16.png");
    private static final ResourceLocation DISABLED_16 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_16_disabled.png");
    private static final ResourceLocation HIGHLIGHT_16 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_16_highlight.png");
    private static final ResourceLocation DEFAULT_32 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_32.png");
    private static final ResourceLocation DISABLED_32 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_32_disabled.png");
    private static final ResourceLocation HIGHLIGHT_32 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_32_highlight.png");
    private static final ResourceLocation DEFAULT_48 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_48.png");
    private static final ResourceLocation DISABLED_48 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_48_disabled.png");
    private static final ResourceLocation HIGHLIGHT_48 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_48_highlight.png");
    private static final ResourceLocation DEFAULT_84 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_84.png");
    private static final ResourceLocation DISABLED_84 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_84_disabled.png");
    private static final ResourceLocation HIGHLIGHT_84 = new ResourceLocation("toukun", "textures/gui/sprites/menu/button_84_highlight.png");

    private static ResourceLocation getButton16(ButtonTypes type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ButtonTypes.DEFAULT -> DEFAULT_16;
            case ButtonTypes.HOVERED -> HIGHLIGHT_16;
            case ButtonTypes.DISABLED -> DISABLED_16;
        };
    }

    private static ResourceLocation getButton32(ButtonTypes type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ButtonTypes.DEFAULT -> DEFAULT_32;
            case ButtonTypes.HOVERED -> HIGHLIGHT_32;
            case ButtonTypes.DISABLED -> DISABLED_32;
        };
    }

    private static ResourceLocation getButton48(ButtonTypes type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ButtonTypes.DEFAULT -> DEFAULT_48;
            case ButtonTypes.HOVERED -> HIGHLIGHT_48;
            case ButtonTypes.DISABLED -> DISABLED_48;
        };
    }

    private static ResourceLocation getButton84(ButtonTypes type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ButtonTypes.DEFAULT -> DEFAULT_84;
            case ButtonTypes.HOVERED -> HIGHLIGHT_84;
            case ButtonTypes.DISABLED -> DISABLED_84;
        };
    }

    private static ResourceLocation getButton(ButtonSizes size, ButtonTypes type) {
        return switch (size) {
            default -> throw new IncompatibleClassChangeError();
            case ButtonSizes.SIZE_16 -> ButtonRenderer.getButton16(type);
            case ButtonSizes.SIZE_32 -> ButtonRenderer.getButton32(type);
            case ButtonSizes.SIZE_48 -> ButtonRenderer.getButton48(type);
            case ButtonSizes.SIZE_84 -> ButtonRenderer.getButton84(type);
        };
    }

    public static void renderButton(GuiGraphics guiGraphics, ButtonSizes size, ButtonTypes type, int x, int y) {
        ResourceLocation texture = ButtonRenderer.getButton(size, type);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)texture);
        guiGraphics.blit(texture, x, y, 0.0f, 0.0f, size.getSize(), 16, size.getSize(), 16);
    }

    public static void renderButtonWithLabel(GuiGraphics guiGraphics, ButtonSizes size, ButtonTypes type, int x, int y, Component label, Font font) {
        ButtonRenderer.renderButton(guiGraphics, size, type, x, y);
        TextRenderer.renderTruncatedButtonLabel(guiGraphics, font, label, size, type, x, y);
    }

    public static void renderIconButton(GuiGraphics guiGraphics, ButtonTypes type, int x, int y, ResourceLocation iconLocation) {
        ButtonSizes size = ButtonSizes.SIZE_16;
        ButtonRenderer.renderButton(guiGraphics, size, type, x, y);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)iconLocation);
        if (type.equals((Object)ButtonTypes.DISABLED)) {
            RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.5f);
        }
        guiGraphics.blit(iconLocation, x, y, 0.0f, 0.0f, size.getSize(), 16, size.getSize(), 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }
}

