/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.client.utility.rendering;

import com.toukun.mymod.client.utility.rendering.ButtonSizes;
import com.toukun.mymod.client.utility.rendering.ButtonTypes;
import com.toukun.mymod.client.utility.rendering.FontColors;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TextRenderer {
    private static final int BUTTON_TEXT_X_OFFSET = 2;
    private static final int BUTTON_TEXT_Y_OFFSET = 4;

    public static FontColors getColorByButtonType(ButtonTypes types) {
        return switch (types) {
            default -> throw new IncompatibleClassChangeError();
            case ButtonTypes.DEFAULT -> FontColors.DEFAULT;
            case ButtonTypes.HOVERED -> FontColors.HOVER;
            case ButtonTypes.DISABLED -> FontColors.DISABLED;
        };
    }

    public static void renderTruncated(GuiGraphics guiGraphics, Font font, Component label, int x, int y, int maxWidth, int color) {
        FormattedText text = font.substrByWidth((FormattedText)label, maxWidth);
        guiGraphics.drawString(font, text.getString(), x, y, color, false);
    }

    public static void renderTruncatedButtonLabel(GuiGraphics guiGraphics, Font font, Component label, ButtonSizes size, ButtonTypes type, int x, int y) {
        TextRenderer.renderTruncatedButtonLabel(guiGraphics, font, label, size.getSize(), TextRenderer.getColorByButtonType(type), x, y);
    }

    public static void renderTruncatedButtonLabel(GuiGraphics guiGraphics, Font font, Component label, int maxWidth, FontColors color, int x, int y) {
        int width = maxWidth - 4;
        TextRenderer.renderTruncated(guiGraphics, font, label, x + 2, y + 4, width, color.getColor());
    }
}

