/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.toukun.mymod.attachments.hearth.HearthAttachmentHandler;
import com.toukun.mymod.network.packets.HearthPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;

public class HearthCommand {
    private static final String HEARTH_CLEARED = "commands.hearth.clear";
    private static final String HEARTH_SET = "commands.hearth.set";
    private static final String HEARTH_GET = "commands.hearth.get";
    private static final String SECONDS_ARGUMENT = "seconds";

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.literal((String)"hearth").requires(commandSourceStack -> commandSourceStack.hasPermission(2) && commandSourceStack.isPlayer());
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(Commands.literal((String)"get").executes(context -> HearthCommand.GetHearth(((CommandSourceStack)context.getSource()).getPlayerOrException())))).then(Commands.literal((String)"set").then(Commands.argument((String)SECONDS_ARGUMENT, (ArgumentType)IntegerArgumentType.integer((int)0, (int)1000000)).executes(context -> HearthCommand.SetHeath(((CommandSourceStack)context.getSource()).getPlayerOrException(), IntegerArgumentType.getInteger((CommandContext)context, (String)SECONDS_ARGUMENT)))))).then(Commands.literal((String)"clear").executes(context -> HearthCommand.ClearHearth(((CommandSourceStack)context.getSource()).getPlayerOrException())));
        commandDispatcher.register(literalArgumentBuilder);
    }

    private static int GetHearth(ServerPlayer player) {
        player.sendSystemMessage((Component)Component.translatable((String)HEARTH_GET, (Object[])new Object[]{HearthAttachmentHandler.GetHearthCooldown(player)}));
        return 0;
    }

    private static int SetHeath(ServerPlayer player, int hearthSeconds) {
        int cooldown = HearthAttachmentHandler.SetHeartCooldown(player, hearthSeconds);
        player.connection.send((CustomPacketPayload)new HearthPacket(cooldown));
        player.sendSystemMessage((Component)Component.translatable((String)HEARTH_SET, (Object[])new Object[]{hearthSeconds}));
        return 0;
    }

    private static int ClearHearth(ServerPlayer player) {
        HearthAttachmentHandler.ClearHearth(player);
        player.connection.send((CustomPacketPayload)new HearthPacket(HearthAttachmentHandler.GetHearthCooldown(player)));
        player.sendSystemMessage((Component)Component.translatable((String)HEARTH_CLEARED));
        return 0;
    }
}

