/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.toukun.mymod.party.PartySystem;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.server.level.ServerPlayer;
import org.slf4j.Logger;

public class PartyCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PLAYER_ARG = "player";
    private static final String NAME_ARG = "name";

    public static void register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.literal((String)"party").requires(CommandSourceStack::isPlayer);
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(Commands.literal((String)"create").executes(context -> PartyCommand.createParty((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"leave").executes(context -> PartyCommand.leaveParty((CommandSourceStack)context.getSource())))).then(Commands.literal((String)"join").then(Commands.argument((String)PLAYER_ARG, (ArgumentType)EntityArgument.player()).executes(context -> PartyCommand.joinParty((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)PLAYER_ARG)))))).then(Commands.literal((String)"rename").then(Commands.argument((String)NAME_ARG, (ArgumentType)StringArgumentType.greedyString()).executes(context -> PartyCommand.changePartyName((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)NAME_ARG)))))).then(Commands.literal((String)"invite").then(Commands.argument((String)PLAYER_ARG, (ArgumentType)EntityArgument.player()).executes(context -> PartyCommand.invitePlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)PLAYER_ARG)))))).then(Commands.literal((String)"remove").then(Commands.argument((String)PLAYER_ARG, (ArgumentType)EntityArgument.player()).executes(context -> PartyCommand.removePlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)PLAYER_ARG)))))).then(Commands.literal((String)"promote").then(Commands.argument((String)PLAYER_ARG, (ArgumentType)EntityArgument.player()).executes(context -> PartyCommand.promotePlayer((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)PLAYER_ARG)))))).then(Commands.literal((String)"teleport").then(Commands.argument((String)PLAYER_ARG, (ArgumentType)EntityArgument.player()).executes(context -> PartyCommand.teleportToMember((CommandSourceStack)context.getSource(), EntityArgument.getPlayer((CommandContext)context, (String)PLAYER_ARG)))))).then(Commands.literal((String)"disband").executes(context -> PartyCommand.disbandParty((CommandSourceStack)context.getSource())));
        commandDispatcher.register(literalArgumentBuilder);
    }

    private static PartySystem getPartySystem(CommandSourceStack source) {
        return new PartySystem(source.getServer(), true);
    }

    public static int createParty(CommandSourceStack source) throws CommandSyntaxException {
        LOGGER.debug("createParty init");
        PartySystem partySystem = PartyCommand.getPartySystem(source);
        ServerPlayer player = source.getPlayerOrException();
        partySystem.createParty(player);
        LOGGER.debug("createParty complete");
        return 0;
    }

    public static int disbandParty(CommandSourceStack source) throws CommandSyntaxException {
        LOGGER.debug("disbandParty init");
        PartySystem partySystem = PartyCommand.getPartySystem(source);
        ServerPlayer player = source.getPlayerOrException();
        partySystem.disbandParty(player);
        LOGGER.debug("disbandParty complete");
        return 0;
    }

    public static int leaveParty(CommandSourceStack source) throws CommandSyntaxException {
        LOGGER.debug("leaveParty init");
        PartySystem partySystem = PartyCommand.getPartySystem(source);
        ServerPlayer player = source.getPlayerOrException();
        partySystem.leaveParty(player);
        LOGGER.debug("leaveParty complete");
        return 0;
    }

    public static int invitePlayer(CommandSourceStack source, ServerPlayer target) throws CommandSyntaxException {
        LOGGER.debug("invitePlayer init");
        PartySystem partySystem = PartyCommand.getPartySystem(source);
        ServerPlayer player = source.getPlayerOrException();
        partySystem.invitePlayerToParty(player, target);
        LOGGER.debug("invitePlayer complete");
        return 0;
    }

    public static int removePlayer(CommandSourceStack source, ServerPlayer target) throws CommandSyntaxException {
        LOGGER.debug("removePlayer init");
        PartySystem partySystem = PartyCommand.getPartySystem(source);
        ServerPlayer player = source.getPlayerOrException();
        partySystem.removeMemberFromParty(player, target);
        LOGGER.debug("removePlayer complete");
        return 0;
    }

    public static int promotePlayer(CommandSourceStack source, ServerPlayer target) throws CommandSyntaxException {
        LOGGER.debug("promotePlayer init");
        PartySystem partySystem = PartyCommand.getPartySystem(source);
        ServerPlayer player = source.getPlayerOrException();
        partySystem.promotePlayerToLeader(player, target);
        LOGGER.debug("promotePlayer complete");
        return 0;
    }

    public static int changePartyName(CommandSourceStack source, String newName) throws CommandSyntaxException {
        LOGGER.debug("changePartyName init");
        PartySystem partySystem = PartyCommand.getPartySystem(source);
        ServerPlayer player = source.getPlayerOrException();
        partySystem.changePartyName(player, newName);
        LOGGER.debug("changePartyName complete");
        return 0;
    }

    public static int joinParty(CommandSourceStack source, ServerPlayer target) throws CommandSyntaxException {
        LOGGER.debug("joinParty init");
        PartySystem partySystem = PartyCommand.getPartySystem(source);
        ServerPlayer player = source.getPlayerOrException();
        partySystem.joinParty(player, target);
        LOGGER.debug("joinParty complete");
        return 0;
    }

    public static int teleportToMember(CommandSourceStack source, ServerPlayer target) throws CommandSyntaxException {
        LOGGER.debug("teleportToMember init");
        PartySystem partySystem = PartyCommand.getPartySystem(source);
        ServerPlayer player = source.getPlayerOrException();
        partySystem.teleportToMember(player, target);
        LOGGER.debug("teleportToMember complete");
        return 0;
    }
}

