/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.config;

import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    public static ModConfigSpec.BooleanValue SHOW_SWING_TIMER;
    public static ModConfigSpec.IntValue DEATH_PENALTY;

    public static void register() {
        Config.registerClientConfigs();
        Config.registerCommonConfigs();
        Config.registerServerConfigs();
    }

    private static void registerClientConfigs() {
        ModConfigSpec.Builder CLIENT_BUILDER = new ModConfigSpec.Builder();
        CLIENT_BUILDER.comment("Settings").push("Swing Timer");
        SHOW_SWING_TIMER = CLIENT_BUILDER.comment("Shows the swing timer on the screen").define("swingTimerVisible", true);
        CLIENT_BUILDER.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)CLIENT_BUILDER.build());
    }

    private static void registerCommonConfigs() {
        ModConfigSpec.Builder COMMON_BUILDER = new ModConfigSpec.Builder();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)COMMON_BUILDER.build());
    }

    private static void registerServerConfigs() {
        ModConfigSpec.Builder SERVER_BUILDER = new ModConfigSpec.Builder();
        SERVER_BUILDER.comment("Settings").push("Death Penalty");
        DEATH_PENALTY = SERVER_BUILDER.comment("Number of levels lost when a player dies").comment("Note: Only in effect for worlds with game rule keepInventory set to true").defineInRange("deathPenalty", 5, 0, 10);
        SERVER_BUILDER.pop();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_BUILDER.build());
    }
}

