/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.datagen;

import com.toukun.mymod.datagen.ModBlockModelProvider;
import com.toukun.mymod.datagen.ModBlockStateProvider;
import com.toukun.mymod.datagen.ModBlockTagGenerator;
import com.toukun.mymod.datagen.ModItemModelProvider;
import com.toukun.mymod.datagen.ModItemTagGenerator;
import com.toukun.mymod.datagen.ModLootTableProvider;
import com.toukun.mymod.datagen.ModPaintingVariantTagProvider;
import com.toukun.mymod.datagen.ModRecipeProvider;
import com.toukun.mymod.datagen.WorldGenProvider;
import com.toukun.mymod.datagen.advancements.ModAdvancementGenerator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@Mod.EventBusSubscriber(modid="toukun", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new WorldGenProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)ModLootTableProvider.Create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockModelProvider(packOutput, existingFileHelper));
        ModBlockTagGenerator blockTagsProvider = new ModBlockTagGenerator(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new ModItemTagGenerator(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new ModPaintingVariantTagProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementProvider(packOutput, lookupProvider, existingFileHelper, List.of(new ModAdvancementGenerator())));
    }
}

