/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.datagen;

import com.toukun.mymod.block.ModBlocks;
import com.toukun.mymod.block.custom.WallSconceBlock;
import com.toukun.mymod.datagen.ModBlockModelProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Direction;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    private static final String SCONCE_TEXTURE = "sconce";
    private static final String SCONCE_TEMPLATE = "template_wall_sconce";
    private final ModBlockModelProvider modModels;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "toukun", exFileHelper);
        this.modModels = new ModBlockModelProvider(output, exFileHelper){

            public CompletableFuture<?> run(CachedOutput cache) {
                return CompletableFuture.allOf(new CompletableFuture[0]);
            }

            @Override
            protected void registerModels() {
            }
        };
    }

    public ModBlockModelProvider modModels() {
        return this.modModels;
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(ModBlocks.SILVER_BLOCK);
        this.blockWithItem(ModBlocks.SILVER_ORE);
        this.blockWithItem(ModBlocks.PORTAL_BLOCK);
        this.blockWithItem(ModBlocks.RAW_SILVER_BLOCK);
        this.blockWithItem(ModBlocks.CHISELED_SMOOTH_STONE_BLOCK);
        this.sconceBlock(ModBlocks.STONE_WALL_SCONCE);
        this.sconceBlock(ModBlocks.SOUL_STONE_WALL_SCONCE);
        this.sconceBlock(ModBlocks.COPPER_WALL_SCONCE);
        this.sconceBlock(ModBlocks.SOUL_COPPER_WALL_SCONCE);
        this.sconceBlock(ModBlocks.IRON_WALL_SCONCE);
        this.sconceBlock(ModBlocks.SOUL_IRON_WALL_SCONCE);
        this.sconceBlock(ModBlocks.GOLD_WALL_SCONCE);
        this.sconceBlock(ModBlocks.SOUL_GOLD_WALL_SCONCE);
        this.sconceBlock(ModBlocks.SILVER_WALL_SCONCE);
        this.sconceBlock(ModBlocks.SOUL_SILVER_WALL_SCONCE);
        this.questBoardBlock(ModBlocks.QUEST_BOARD);
    }

    private void blockWithItem(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void sconceBlock(DeferredBlock<Block> blockRegistryObject) {
        Block block = (Block)blockRegistryObject.get();
        BlockModelBuilder sconceModel = this.modModels().sconce(blockRegistryObject.getId().getPath());
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$sconceBlock$0((ModelFile)sconceModel, arg_0));
    }

    private void questBoardBlock(DeferredBlock<Block> blockRegistryObject) {
        Block block = (Block)blockRegistryObject.get();
        ModelFile.ExistingModelFile questBlockModel = this.modModels().getExistingFile(new ResourceLocation("toukun", blockRegistryObject.getId().getPath()));
        this.getVariantBuilder(block).forAllStates(arg_0 -> ModBlockStateProvider.lambda$questBoardBlock$1((ModelFile)questBlockModel, arg_0));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$questBoardBlock$1(ModelFile questBlockModel, BlockState blockState) {
        Direction facing = (Direction)blockState.getValue((Property)WallSconceBlock.FACING);
        return ConfiguredModel.builder().modelFile(questBlockModel).rotationY((int)facing.getOpposite().toYRot()).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$sconceBlock$0(ModelFile sconceModel, BlockState blockState) {
        Direction facing = (Direction)blockState.getValue((Property)WallSconceBlock.FACING);
        return ConfiguredModel.builder().modelFile(sconceModel).rotationY((int)facing.getOpposite().toYRot()).build();
    }
}

