/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.datagen;

import com.toukun.mymod.block.ModBlocks;
import com.toukun.mymod.datagen.models.ArmorTrimInfo;
import com.toukun.mymod.datagen.models.ArmorTrimInfos;
import com.toukun.mymod.item.ModItems;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    private static final List<ArmorTrimInfo> ARMOR_TRIMS = List.of(ArmorTrimInfos.QUARTZ, ArmorTrimInfos.IRON, ArmorTrimInfos.NETHERITE, ArmorTrimInfos.REDSTONE, ArmorTrimInfos.COPPER, ArmorTrimInfos.GOLD, ArmorTrimInfos.EMERALD, ArmorTrimInfos.DIAMOND, ArmorTrimInfos.LAPIS, ArmorTrimInfos.AMETHYST);

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "toukun", existingFileHelper);
    }

    protected void registerModels() {
        this.simpleItem(ModItems.BEEF_STEW);
        this.simpleItem(ModItems.CHAIN_SHEET);
        this.simpleItemFromBlock(ModBlocks.COPPER_WALL_SCONCE);
        this.simpleHandheld(ModItems.DIAMOND_BATTLE_AXE);
        this.simpleHandheld(ModItems.DIAMOND_BLADE);
        this.simpleHandheld(ModItems.DIAMOND_KATANA);
        this.simpleHandheld(ModItems.DIAMOND_SPEAR);
        this.simpleHandheld(ModItems.DIAMOND_WAR_HAMMER);
        this.throwingKnife(ModItems.FLINT_THROWING_KNIFE);
        this.simpleItem(ModItems.FRIEND_RADAR);
        this.simpleItemFromBlock(ModBlocks.GOLD_WALL_SCONCE);
        this.simpleHandheld(ModItems.GOLDEN_BATTLE_AXE);
        this.simpleHandheld(ModItems.GOLDEN_BLADE);
        this.simpleHandheld(ModItems.GOLDEN_KATANA);
        this.simpleHandheld(ModItems.GOLDEN_SPEAR);
        this.simpleHandheld(ModItems.GOLDEN_WAR_HAMMER);
        this.simpleHandheld(ModItems.IRON_BATTLE_AXE);
        this.simpleHandheld(ModItems.IRON_BLADE);
        this.simpleHandheld(ModItems.IRON_KATANA);
        this.simpleHandheld(ModItems.IRON_SPEAR);
        this.simpleItemFromBlock(ModBlocks.IRON_WALL_SCONCE);
        this.simpleHandheld(ModItems.IRON_WAR_HAMMER);
        this.throwingKnife(ModItems.IRON_THROWING_KNIFE);
        this.simpleHandheld(ModItems.NETHERITE_BATTLE_AXE);
        this.simpleHandheld(ModItems.NETHERITE_BLADE);
        this.simpleHandheld(ModItems.NETHERITE_KATANA);
        this.simpleHandheld(ModItems.NETHERITE_SPEAR);
        this.simpleHandheld(ModItems.NETHERITE_WAR_HAMMER);
        this.armorWithTrim(ModItems.NETHERITE_CHAINMAIL_BOOTS, ModItems.NETHERITE_CHAINMAIL_CHESTPLATE, ModItems.NETHERITE_CHAINMAIL_HELMET, ModItems.NETHERITE_CHAINMAIL_LEGGINGS);
        this.throwingKnife(ModItems.OBSIDIAN_THROWING_KNIFE);
        this.simpleHandheld(ModItems.PORTAL_STONE);
        this.simpleBlock(ModBlocks.QUEST_BOARD);
        this.simpleHandheld(ModItems.QUEST_EASY);
        this.simpleHandheld(ModItems.RAW_SILVER);
        this.simpleItem(ModItems.SILVER_INGOT);
        this.simpleItem(ModItems.SILVER_NUGGET);
        this.simpleItemFromBlock(ModBlocks.SILVER_WALL_SCONCE);
        this.simpleItemFromBlock(ModBlocks.SOUL_COPPER_WALL_SCONCE);
        this.simpleItemFromBlock(ModBlocks.SOUL_GOLD_WALL_SCONCE);
        this.simpleItemFromBlock(ModBlocks.SOUL_IRON_WALL_SCONCE);
        this.simpleItemFromBlock(ModBlocks.SOUL_SILVER_WALL_SCONCE);
        this.simpleItemFromBlock(ModBlocks.SOUL_STONE_WALL_SCONCE);
        this.simpleHandheld(ModItems.STONE_BATTLE_AXE);
        this.simpleHandheld(ModItems.STONE_BLADE);
        this.simpleHandheld(ModItems.STONE_KATANA);
        this.simpleHandheld(ModItems.STONE_SPEAR);
        this.simpleItemFromBlock(ModBlocks.STONE_WALL_SCONCE);
        this.simpleHandheld(ModItems.STONE_WAR_HAMMER);
        this.simpleHandheld(ModItems.WOODEN_BATTLE_AXE);
        this.simpleHandheld(ModItems.WOODEN_BLADE);
        this.simpleHandheld(ModItems.WOODEN_KATANA);
        this.simpleHandheld(ModItems.WOODEN_SPEAR);
        this.simpleHandheld(ModItems.WOODEN_WAR_HAMMER);
        this.simpleHandheld(ModItems.WOODEN_MAGE_STAFF);
        this.simpleHandheld(ModItems.STONE_MAGE_STAFF);
        this.simpleHandheld(ModItems.IRON_MAGE_STAFF);
        this.simpleHandheld(ModItems.GOLDEN_MAGE_STAFF);
        this.simpleHandheld(ModItems.DIAMOND_MAGE_STAFF);
        this.simpleHandheld(ModItems.NETHERITE_MAGE_STAFF);
        this.simpleItem(ModItems.MAGIC_BOLT);
        ((ItemModelBuilder)this.withExistingParent(new ResourceLocation("toukun", "shulker_bundle_filled").toString(), "item/generated")).texture("layer0", new ResourceLocation("toukun", "item/shulker_bundle_filled"));
        this.simpleItem(ModItems.SHULKER_BUNDLE).override().predicate(new ResourceLocation("toukun", "filled"), 1.0E-7f).model((ModelFile)this.getExistingFile(new ResourceLocation("toukun", "shulker_bundle_filled")));
    }

    private ItemModelBuilder itemWithParent(DeferredItem<Item> item, ResourceLocation parent) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), parent)).texture("layer0", new ResourceLocation("toukun", "item/" + item.getId().getPath()));
    }

    private ItemModelBuilder simpleItem(DeferredItem<Item> item) {
        return this.itemWithParent(item, new ResourceLocation("item/generated"));
    }

    private ItemModelBuilder simpleHandheld(DeferredItem<Item> item) {
        return this.itemWithParent(item, new ResourceLocation("item/handheld"));
    }

    private ItemModelBuilder throwingKnife(DeferredItem<Item> item) {
        return this.itemWithParent(item, new ResourceLocation("toukun", "item/template_throwing_knife"));
    }

    private ItemModelBuilder simpleItemFromBlock(DeferredBlock<Block> block) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("toukun", "item/" + block.getId().getPath()));
    }

    private ItemModelBuilder simpleBlock(DeferredBlock<Block> block) {
        return (ItemModelBuilder)this.withExistingParent(block.getId().getPath(), new ResourceLocation("toukun", "block/" + block.getId().getPath()));
    }

    private ItemModelBuilder generateArmorTrimModel(DeferredItem<Item> armor, String trimSuffix, String trimTexturePath) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(armor.getId().getPath() + trimSuffix, new ResourceLocation("item/generated"))).texture("layer0", new ResourceLocation("toukun", "item/" + armor.getId().getPath()))).texture("layer1", new ResourceLocation(trimTexturePath));
    }

    private void armorWithTrim(DeferredItem<Item> boots, DeferredItem<Item> chestPlate, DeferredItem<Item> helmet, DeferredItem<Item> leggings) {
        String bootsBaseName = "item/" + boots.getId().getPath();
        String chestplateBaseName = "item/" + chestPlate.getId().getPath();
        String helmetBaseName = "item/" + helmet.getId().getPath();
        String leggingsBaseName = "item/" + leggings.getId().getPath();
        ItemModelBuilder bootsBuilder = this.simpleItem(boots);
        ItemModelBuilder chestPlateBuilder = this.simpleItem(chestPlate);
        ItemModelBuilder helmetBuilder = this.simpleItem(helmet);
        ItemModelBuilder leggingsBuilder = this.simpleItem(leggings);
        for (ArmorTrimInfo info : ARMOR_TRIMS) {
            String suffix = info.getPredicateModelSuffix();
            float value = info.getPredicateValue();
            this.generateArmorTrimModel(boots, info.getPredicateModelSuffix(), info.getTrimPath(ArmorItem.Type.BOOTS));
            this.generateArmorTrimModel(chestPlate, suffix, info.getTrimPath(ArmorItem.Type.CHESTPLATE));
            this.generateArmorTrimModel(helmet, suffix, info.getTrimPath(ArmorItem.Type.HELMET));
            this.generateArmorTrimModel(leggings, suffix, info.getTrimPath(ArmorItem.Type.LEGGINGS));
            bootsBuilder = bootsBuilder.override().model((ModelFile)this.getExistingFile(new ResourceLocation("toukun", bootsBaseName + suffix))).predicate(new ResourceLocation("trim_type"), value).end();
            chestPlateBuilder = chestPlateBuilder.override().model((ModelFile)this.getExistingFile(new ResourceLocation("toukun", chestplateBaseName + suffix))).predicate(new ResourceLocation("trim_type"), value).end();
            helmetBuilder = helmetBuilder.override().model((ModelFile)this.getExistingFile(new ResourceLocation("toukun", helmetBaseName + suffix))).predicate(new ResourceLocation("trim_type"), value).end();
            leggingsBuilder = leggingsBuilder.override().model((ModelFile)this.getExistingFile(new ResourceLocation("toukun", leggingsBaseName + suffix))).predicate(new ResourceLocation("trim_type"), value).end();
        }
    }
}

