/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.datagen;

import com.google.common.collect.ImmutableList;
import com.toukun.mymod.block.ModBlocks;
import com.toukun.mymod.datagen.recipe.PortalStoneDuplicateRecipeBuilder;
import com.toukun.mymod.item.ModItems;
import java.util.List;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.conditions.IConditionBuilder;

public class ModRecipeProvider
extends RecipeProvider
implements IConditionBuilder {
    private static final String HAS_PRIMARY_INGREDIENT = "has_primary_ingredient";
    private static final String HAS_SOURCE_INGREDIENT = "has_source_ingredient";
    private static final String SILVER_INGOT_GROUP = "silver_ingot";
    private static final String GOLD_NUGGET_GROUP = "gold_nugget";
    private static final String IRON_NUGGET_GROUP = "iron_nugget";
    private static final String BEEF_STEW_GROUP = "beef_stew";
    private static final ImmutableList<ItemLike> SILVER_SMELTABLES = ImmutableList.of((Object)((ItemLike)ModItems.RAW_SILVER.get()), (Object)((ItemLike)ModBlocks.SILVER_ORE.get()));
    private static final ImmutableList<ItemLike> IRON_SMELTABLES = ImmutableList.of((Object)((ItemLike)ModItems.IRON_BLADE.get()), (Object)((ItemLike)ModItems.IRON_KATANA.get()), (Object)((ItemLike)ModItems.IRON_SPEAR.get()), (Object)((ItemLike)ModItems.IRON_BATTLE_AXE.get()), (Object)((ItemLike)ModItems.IRON_WAR_HAMMER.get()));
    private static final ImmutableList<ItemLike> GOLD_SMELTABLES = ImmutableList.of((Object)((ItemLike)ModItems.GOLDEN_BLADE.get()), (Object)((ItemLike)ModItems.GOLDEN_KATANA.get()), (Object)((ItemLike)ModItems.GOLDEN_SPEAR.get()), (Object)((ItemLike)ModItems.GOLDEN_BATTLE_AXE.get()), (Object)((ItemLike)ModItems.GOLDEN_WAR_HAMMER.get()));

    public ModRecipeProvider(PackOutput packOutput) {
        super(packOutput);
    }

    private static String getCustomPacking(String name) {
        return "toukun:" + name;
    }

    private static String getCustomBreakdownPacking(String resultName, String baseName) {
        return resultName + "_breakdown_from_" + baseName;
    }

    protected static void oreSmelting(RecipeOutput output, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime).group(pGroup).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemlike), ModRecipeProvider.has((ItemLike)itemlike)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)pResult)) + "_from_smelting_" + ModRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }

    protected static void oreBlasting(RecipeOutput output, List<ItemLike> pIngredients, RecipeCategory pCategory, ItemLike pResult, float pExperience, int pCookingTime, String pGroup) {
        for (ItemLike itemlike : pIngredients) {
            SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{itemlike}), (RecipeCategory)pCategory, (ItemLike)pResult, (float)pExperience, (int)pCookingTime).group(pGroup).unlockedBy(ModRecipeProvider.getHasName((ItemLike)itemlike), ModRecipeProvider.has((ItemLike)itemlike)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)pResult)) + "_from_blasting_" + ModRecipeProvider.getItemName((ItemLike)itemlike));
        }
    }

    protected static void netheriteSmithing(RecipeOutput output, Item sourceItem, RecipeCategory category, Item resultItem) {
        SmithingTransformRecipeBuilder.smithing((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_UPGRADE_SMITHING_TEMPLATE}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{sourceItem}), (Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}), (RecipeCategory)category, (Item)resultItem).unlocks("has_netherite_ingot", ModRecipeProvider.has((ItemLike)Items.NETHERITE_INGOT)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)resultItem)) + "_smithing");
    }

    protected static String getConversionRecipeName(ItemLike result, ItemLike ingredient) {
        return ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)result)) + "_from_" + ModRecipeProvider.getItemName((ItemLike)ingredient);
    }

    protected void buildRecipes(RecipeOutput output) {
        ModRecipeProvider.nineBlockStorageRecipes((RecipeOutput)output, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_INGOT.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SILVER_BLOCK.get()), (String)ModRecipeProvider.getCustomPacking(ModItems.SILVER_INGOT.getId().getPath()), null, (String)ModRecipeProvider.getCustomPacking(ModBlocks.SILVER_BLOCK.getId().getPath()), (String)SILVER_INGOT_GROUP);
        ModRecipeProvider.nineBlockStorageRecipes((RecipeOutput)output, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.RAW_SILVER.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.RAW_SILVER_BLOCK.get()), (String)ModRecipeProvider.getCustomPacking(ModItems.RAW_SILVER.getId().getPath()), null, (String)ModRecipeProvider.getCustomPacking(ModBlocks.RAW_SILVER_BLOCK.getId().getPath()), null);
        ModRecipeProvider.nineBlockStorageRecipes((RecipeOutput)output, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_NUGGET.get()), (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SILVER_INGOT.get()), (String)ModRecipeProvider.getCustomPacking(ModItems.SILVER_NUGGET.getId().getPath()), (String)SILVER_INGOT_GROUP, (String)ModRecipeProvider.getCustomPacking(ModItems.SILVER_INGOT.getId().getPath() + "_from_nuggets"), null);
        ModRecipeProvider.oreBlasting(output, SILVER_SMELTABLES, RecipeCategory.MISC, (ItemLike)ModItems.SILVER_INGOT.get(), 1.0f, 100, SILVER_INGOT_GROUP);
        ModRecipeProvider.oreSmelting(output, SILVER_SMELTABLES, RecipeCategory.MISC, (ItemLike)ModItems.SILVER_INGOT.get(), 1.0f, 200, SILVER_INGOT_GROUP);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.BEEF_STEW.get())).requires((ItemLike)Items.BAKED_POTATO).requires((ItemLike)Items.COOKED_BEEF).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.BROWN_MUSHROOM).group(BEEF_STEW_GROUP).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.COOKED_BEEF)).save(output, ModRecipeProvider.getConversionRecipeName((ItemLike)ModItems.BEEF_STEW.get(), (ItemLike)Items.BROWN_MUSHROOM));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)((ItemLike)ModItems.BEEF_STEW.get())).requires((ItemLike)Items.BAKED_POTATO).requires((ItemLike)Items.COOKED_BEEF).requires((ItemLike)Items.BOWL).requires((ItemLike)Items.CARROT).requires((ItemLike)Items.RED_MUSHROOM).group(BEEF_STEW_GROUP).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.COOKED_BEEF)).save(output, ModRecipeProvider.getConversionRecipeName((ItemLike)ModItems.BEEF_STEW.get(), (ItemLike)Items.RED_MUSHROOM));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BELL).pattern(" # ").pattern(" X ").pattern("XYX").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('Y'), (ItemLike)Items.IRON_NUGGET).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.BELL)));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.BUNDLE).pattern("#X#").pattern("X X").pattern(" X ").define(Character.valueOf('#'), (ItemLike)Items.STRING).define(Character.valueOf('X'), (ItemLike)Items.LEATHER).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.LEATHER)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.BUNDLE)));
        ModRecipeProvider.twoByTwoPacker((RecipeOutput)output, (RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.CHAIN_SHEET.get()), (ItemLike)Items.IRON_NUGGET);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.CHAINMAIL_BOOTS).pattern("# #").pattern("# #").define(Character.valueOf('#'), (ItemLike)ModItems.CHAIN_SHEET.get()).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHAIN_SHEET.get()))).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.CHAINMAIL_BOOTS)));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.CHAINMAIL_CHESTPLATE).pattern("# #").pattern("###").pattern("###").define(Character.valueOf('#'), (ItemLike)ModItems.CHAIN_SHEET.get()).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHAIN_SHEET.get()))).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.CHAINMAIL_CHESTPLATE)));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.CHAINMAIL_HELMET).pattern("###").pattern("# #").define(Character.valueOf('#'), (ItemLike)ModItems.CHAIN_SHEET.get()).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHAIN_SHEET.get()))).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.CHAINMAIL_HELMET)));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)Items.CHAINMAIL_LEGGINGS).pattern("###").pattern("# #").pattern("# #").define(Character.valueOf('#'), (ItemLike)ModItems.CHAIN_SHEET.get()).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.CHAIN_SHEET.get()))).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.CHAINMAIL_LEGGINGS)));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DIAMOND_HORSE_ARMOR).pattern("# #").pattern("#X#").pattern("# #").define(Character.valueOf('#'), (ItemLike)Items.DIAMOND).define(Character.valueOf('X'), (ItemLike)Items.LEATHER).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.DIAMOND)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.DIAMOND_HORSE_ARMOR)));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DIAMOND).requires((ItemLike)Items.DIAMOND_HORSE_ARMOR).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.DIAMOND_HORSE_ARMOR)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getCustomBreakdownPacking(ModRecipeProvider.getItemName((ItemLike)Items.DIAMOND), ModRecipeProvider.getItemName((ItemLike)Items.DIAMOND_HORSE_ARMOR))));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.GOLDEN_HORSE_ARMOR).pattern("# #").pattern("#X#").pattern("# #").define(Character.valueOf('#'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('X'), (ItemLike)Items.LEATHER).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.GOLDEN_HORSE_ARMOR)));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.IRON_HORSE_ARMOR).pattern("# #").pattern("#X#").pattern("# #").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('X'), (ItemLike)Items.LEATHER).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.IRON_HORSE_ARMOR)));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.FLINT).requires((ItemLike)Items.GRAVEL).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GRAVEL)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getCustomBreakdownPacking(ModRecipeProvider.getItemName((ItemLike)Items.FLINT), ModRecipeProvider.getItemName((ItemLike)Items.GRAVEL))));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.FLINT_THROWING_KNIFE.get()), (int)2).pattern(" X").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.FLINT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.FLINT)).unlockedBy(HAS_SOURCE_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GRAVEL)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.IRON_THROWING_KNIFE.get()), (int)2).pattern(" X").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.IRON_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.OBSIDIAN_THROWING_KNIFE.get()), (int)2).pattern(" X").pattern("# ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.OBSIDIAN).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.OBSIDIAN)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.FRIEND_RADAR.get())).pattern(" # ").pattern("#X#").pattern(" # ").define(Character.valueOf('#'), (ItemLike)ModItems.SILVER_INGOT.get()).define(Character.valueOf('X'), (ItemLike)Items.REDSTONE).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.REDSTONE)).save(output);
        ModRecipeProvider.oreBlasting(output, IRON_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, 0.1f, 100, IRON_NUGGET_GROUP);
        ModRecipeProvider.oreSmelting(output, IRON_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.IRON_NUGGET, 0.1f, 200, IRON_NUGGET_GROUP);
        ModRecipeProvider.oreBlasting(output, GOLD_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, 0.1f, 100, GOLD_NUGGET_GROUP);
        ModRecipeProvider.oreSmelting(output, GOLD_SMELTABLES, RecipeCategory.MISC, (ItemLike)Items.GOLD_NUGGET, 0.1f, 200, GOLD_NUGGET_GROUP);
        ModRecipeProvider.netheriteSmithing(output, (Item)ModItems.DIAMOND_BATTLE_AXE.get(), RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_BATTLE_AXE.get());
        ModRecipeProvider.netheriteSmithing(output, (Item)ModItems.DIAMOND_BLADE.get(), RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_BLADE.get());
        ModRecipeProvider.netheriteSmithing(output, (Item)ModItems.DIAMOND_KATANA.get(), RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_KATANA.get());
        ModRecipeProvider.netheriteSmithing(output, (Item)ModItems.DIAMOND_SPEAR.get(), RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_SPEAR.get());
        ModRecipeProvider.netheriteSmithing(output, (Item)ModItems.DIAMOND_WAR_HAMMER.get(), RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_WAR_HAMMER.get());
        ModRecipeProvider.netheriteSmithing(output, (Item)ModItems.DIAMOND_MAGE_STAFF.get(), RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_MAGE_STAFF.get());
        ModRecipeProvider.netheriteSmithing(output, Items.CHAINMAIL_BOOTS, RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_CHAINMAIL_BOOTS.get());
        ModRecipeProvider.netheriteSmithing(output, Items.CHAINMAIL_CHESTPLATE, RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_CHAINMAIL_CHESTPLATE.get());
        ModRecipeProvider.netheriteSmithing(output, Items.CHAINMAIL_HELMET, RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_CHAINMAIL_HELMET.get());
        ModRecipeProvider.netheriteSmithing(output, Items.CHAINMAIL_LEGGINGS, RecipeCategory.COMBAT, (Item)ModItems.NETHERITE_CHAINMAIL_LEGGINGS.get());
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.PORTAL_BLOCK.get())).pattern("#X#").pattern("XYX").pattern("#X#").define(Character.valueOf('#'), (ItemLike)ModItems.SILVER_INGOT.get()).define(Character.valueOf('X'), (ItemLike)Items.CRYING_OBSIDIAN).define(Character.valueOf('Y'), (ItemLike)Items.ENDER_EYE).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.CRYING_OBSIDIAN)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.PORTAL_STONE.get())).pattern(" #Y").pattern("#X#").pattern("Y# ").define(Character.valueOf('#'), (ItemLike)ModItems.SILVER_INGOT.get()).define(Character.valueOf('X'), (ItemLike)Items.CRYING_OBSIDIAN).define(Character.valueOf('Y'), (ItemLike)Items.ENDER_PEARL).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.CRYING_OBSIDIAN)).save(output);
        PortalStoneDuplicateRecipeBuilder.create().unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.PORTAL_STONE.get()))).save(output, new ResourceLocation("toukun", "portal_stone_duplicate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.QUEST_BOARD.get())).pattern("XXX").pattern("#Y#").pattern("XXX").define(Character.valueOf('#'), (ItemLike)Items.PAPER).define(Character.valueOf('X'), ItemTags.PLANKS).define(Character.valueOf('Y'), (ItemLike)Items.EMERALD).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.EMERALD)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.SADDLE).pattern(" # ").pattern("X#X").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.LEATHER).define(Character.valueOf('X'), (ItemLike)Items.STRING).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.LEATHER)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getItemName((ItemLike)Items.SADDLE)));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.LEATHER).requires((ItemLike)Items.SADDLE).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.SADDLE)).save(output, ModRecipeProvider.getCustomPacking(ModRecipeProvider.getCustomBreakdownPacking(ModRecipeProvider.getItemName((ItemLike)Items.LEATHER), ModRecipeProvider.getItemName((ItemLike)Items.SADDLE))));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.STONE_WALL_SCONCE.get())).pattern("X").pattern("#").define(Character.valueOf('#'), ItemTags.STONE_TOOL_MATERIALS).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.COALS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.COPPER_WALL_SCONCE.get())).pattern("X").pattern("#").define(Character.valueOf('#'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.COPPER_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.IRON_WALL_SCONCE.get())).pattern("X").pattern("#").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.GOLD_WALL_SCONCE.get())).pattern("X").pattern("#").define(Character.valueOf('#'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SILVER_WALL_SCONCE.get())).pattern("X").pattern("#").define(Character.valueOf('#'), (ItemLike)ModItems.SILVER_INGOT.get()).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)((ItemLike)ModItems.SILVER_INGOT.get()))).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SOUL_STONE_WALL_SCONCE.get())).pattern("X").pattern("#").pattern("Y").define(Character.valueOf('#'), ItemTags.STONE_TOOL_MATERIALS).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).define(Character.valueOf('Y'), ItemTags.SOUL_FIRE_BASE_BLOCKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SOUL_COPPER_WALL_SCONCE.get())).pattern("X").pattern("#").pattern("Y").define(Character.valueOf('#'), (ItemLike)Items.COPPER_INGOT).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).define(Character.valueOf('Y'), ItemTags.SOUL_FIRE_BASE_BLOCKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SOUL_IRON_WALL_SCONCE.get())).pattern("X").pattern("#").pattern("Y").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).define(Character.valueOf('Y'), ItemTags.SOUL_FIRE_BASE_BLOCKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SOUL_GOLD_WALL_SCONCE.get())).pattern("X").pattern("#").pattern("Y").define(Character.valueOf('#'), (ItemLike)Items.GOLD_INGOT).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).define(Character.valueOf('Y'), ItemTags.SOUL_FIRE_BASE_BLOCKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.SOUL_SILVER_WALL_SCONCE.get())).pattern("X").pattern("#").pattern("Y").define(Character.valueOf('#'), (ItemLike)ModItems.SILVER_INGOT.get()).define(Character.valueOf('X'), Ingredient.of((ItemLike[])new ItemLike[]{Items.COAL, Items.CHARCOAL})).define(Character.valueOf('Y'), ItemTags.SOUL_FIRE_BASE_BLOCKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.SOUL_FIRE_BASE_BLOCKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.WOODEN_BATTLE_AXE.get())).pattern("X  ").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.STONE_BATTLE_AXE.get())).pattern("X  ").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.STONE_TOOL_MATERIALS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.IRON_BATTLE_AXE.get())).pattern("X  ").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.IRON_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.GOLDEN_BATTLE_AXE.get())).pattern("X  ").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.GOLD_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DIAMOND_BATTLE_AXE.get())).pattern("X  ").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.DIAMOND).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.DIAMOND)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.WOODEN_BLADE.get())).pattern("#XX").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.STONE_BLADE.get())).pattern("#XX").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.STONE_TOOL_MATERIALS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.IRON_BLADE.get())).pattern("#XX").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.IRON_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.GOLDEN_BLADE.get())).pattern("#XX").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.GOLD_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DIAMOND_BLADE.get())).pattern("#XX").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.DIAMOND).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.DIAMOND)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.WOODEN_KATANA.get())).pattern("  X").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.STONE_KATANA.get())).pattern("  X").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.STONE_TOOL_MATERIALS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.IRON_KATANA.get())).pattern("  X").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.IRON_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.GOLDEN_KATANA.get())).pattern("  X").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.GOLD_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DIAMOND_KATANA.get())).pattern("  X").pattern(" X ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.DIAMOND).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.DIAMOND)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.WOODEN_SPEAR.get())).pattern(" XX").pattern(" # ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.STONE_SPEAR.get())).pattern(" XX").pattern(" # ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.STONE_TOOL_MATERIALS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.IRON_SPEAR.get())).pattern(" XX").pattern(" # ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.IRON_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.GOLDEN_SPEAR.get())).pattern(" XX").pattern(" # ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.GOLD_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DIAMOND_SPEAR.get())).pattern(" XX").pattern(" # ").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.DIAMOND).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.DIAMOND)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.WOODEN_WAR_HAMMER.get())).pattern(" X ").pattern(" #X").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.STONE_WAR_HAMMER.get())).pattern(" X ").pattern(" #X").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.STONE_TOOL_MATERIALS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.IRON_WAR_HAMMER.get())).pattern(" X ").pattern(" #X").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.IRON_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.GOLDEN_WAR_HAMMER.get())).pattern(" X ").pattern(" #X").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.GOLD_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DIAMOND_WAR_HAMMER.get())).pattern(" X ").pattern(" #X").pattern("#  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.DIAMOND).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.DIAMOND)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.SHULKER_BUNDLE.get())).pattern(" X ").pattern("Y#Y").pattern(" X ").define(Character.valueOf('#'), (ItemLike)Items.BUNDLE).define(Character.valueOf('X'), (ItemLike)Items.SHULKER_SHELL).define(Character.valueOf('Y'), (ItemLike)Items.ENDER_PEARL).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.SHULKER_SHELL)).save(output);
        ModRecipeProvider.stonecutterResultFromBase((RecipeOutput)output, (RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModBlocks.CHISELED_SMOOTH_STONE_BLOCK.get()), (ItemLike)Blocks.SMOOTH_STONE);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.WOODEN_MAGE_STAFF.get())).pattern("  X").pattern(" # ").pattern("X  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.PLANKS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.PLANKS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.STONE_MAGE_STAFF.get())).pattern("  X").pattern(" # ").pattern("X  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), ItemTags.STONE_TOOL_MATERIALS).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((TagKey)ItemTags.STONE_TOOL_MATERIALS)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.IRON_MAGE_STAFF.get())).pattern("  X").pattern(" # ").pattern("X  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.IRON_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.GOLDEN_MAGE_STAFF.get())).pattern("  X").pattern(" # ").pattern("X  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.GOLD_INGOT).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.GOLD_INGOT)).save(output);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.DIAMOND_MAGE_STAFF.get())).pattern("  X").pattern(" # ").pattern("X  ").define(Character.valueOf('#'), (ItemLike)Items.STICK).define(Character.valueOf('X'), (ItemLike)Items.DIAMOND).unlockedBy(HAS_PRIMARY_INGREDIENT, ModRecipeProvider.has((ItemLike)Items.DIAMOND)).save(output);
    }
}

