/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.datagen.advancements;

import com.toukun.mymod.advancements.criteria.DashTrigger;
import com.toukun.mymod.advancements.criteria.HearthTrigger;
import com.toukun.mymod.block.ModBlocks;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.neoforge.common.data.AdvancementProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModAdvancementGenerator
implements AdvancementProvider.AdvancementGenerator {
    private static final String TRIGGER = "trigger";

    private static Component GetTitle(String name) {
        return Component.translatable((String)String.format("advancements.toukun.%s.title", name));
    }

    private static Component GetDescription(String name) {
        return Component.translatable((String)String.format("advancements.toukun.%s.description", name));
    }

    private static ResourceLocation GetLocation(String path) {
        return new ResourceLocation("toukun", path);
    }

    public void generate(HolderLookup.Provider provider, Consumer<AdvancementHolder> consumer, ExistingFileHelper existingFileHelper) {
        AdvancementHolder root = Advancement.Builder.advancement().addCriterion(TRIGGER, PlayerTrigger.TriggerInstance.tick()).display((ItemLike)ModBlocks.CHISELED_SMOOTH_STONE_BLOCK.get(), ModAdvancementGenerator.GetTitle("root"), ModAdvancementGenerator.GetDescription("root"), new ResourceLocation("minecraft:textures/gui/advancements/backgrounds/stone.png"), AdvancementType.TASK, false, false, false).requirements(AdvancementRequirements.allOf(List.of(TRIGGER))).save(consumer, ModAdvancementGenerator.GetLocation("root"), existingFileHelper);
        AdvancementHolder hearth = Advancement.Builder.advancement().addCriterion(TRIGGER, HearthTrigger.HearthTriggerInstance.hearthed()).parent(root).display((ItemLike)Blocks.RED_BED, ModAdvancementGenerator.GetTitle("hearth"), ModAdvancementGenerator.GetDescription("hearth"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.allOf(List.of(TRIGGER))).save(consumer, ModAdvancementGenerator.GetLocation("hearth"), existingFileHelper);
        AdvancementHolder dash = Advancement.Builder.advancement().addCriterion(TRIGGER, DashTrigger.DashTriggerInstance.dashed()).parent(root).display((ItemLike)Items.LEATHER_BOOTS, ModAdvancementGenerator.GetTitle("dash"), ModAdvancementGenerator.GetDescription("dash"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.allOf(List.of(TRIGGER))).save(consumer, ModAdvancementGenerator.GetLocation("dash/dash"), existingFileHelper);
        AdvancementHolder dwgr = Advancement.Builder.advancement().addCriterion(TRIGGER, DashTrigger.DashTriggerInstance.cooldownLessThan(60)).parent(dash).display((ItemLike)Items.GOLDEN_BOOTS, ModAdvancementGenerator.GetTitle("dwgr"), ModAdvancementGenerator.GetDescription("dwgr"), null, AdvancementType.GOAL, true, true, false).requirements(AdvancementRequirements.allOf(List.of(TRIGGER))).save(consumer, ModAdvancementGenerator.GetLocation("dash/dwgr"), existingFileHelper);
        AdvancementHolder fatRoll = Advancement.Builder.advancement().addCriterion(TRIGGER, DashTrigger.DashTriggerInstance.cooldownGreaterThan(83)).parent(dash).display((ItemLike)Items.IRON_CHESTPLATE, ModAdvancementGenerator.GetTitle("fat_roll"), ModAdvancementGenerator.GetDescription("fat_roll"), null, AdvancementType.TASK, true, true, false).requirements(AdvancementRequirements.allOf(List.of(TRIGGER))).save(consumer, ModAdvancementGenerator.GetLocation("dash/fat_roll"), existingFileHelper);
    }
}

