/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.datagen.models;

import com.toukun.mymod.datagen.models.ArmorTrimInfo;
import net.minecraft.world.item.ArmorItem;

public enum ArmorTrimInfos implements ArmorTrimInfo
{
    QUARTZ(0.1f, "quartz"),
    IRON(0.2f, "iron"),
    NETHERITE(0.3f, "netherite"),
    REDSTONE(0.4f, "redstone"),
    COPPER(0.5f, "copper"),
    GOLD(0.6f, "gold"),
    EMERALD(0.7f, "emerald"),
    DIAMOND(0.8f, "diamond"),
    LAPIS(0.9f, "lapis"),
    AMETHYST(1.0f, "amethyst");

    private static final String TRIM_PATH = "trims/items/";
    private final float predicateValue;
    private final String modelSuffix;
    private final String trimPathSuffix;

    private ArmorTrimInfos(float predicateValue, String materialName) {
        this.predicateValue = predicateValue;
        this.modelSuffix = "_" + materialName + "_trim";
        this.trimPathSuffix = "_trim_" + materialName;
    }

    @Override
    public float getPredicateValue() {
        return this.predicateValue;
    }

    @Override
    public String getPredicateModelSuffix() {
        return this.modelSuffix;
    }

    @Override
    public String getTrimPath(ArmorItem.Type type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ArmorItem.Type.HELMET -> "trims/items/helmet" + this.trimPathSuffix;
            case ArmorItem.Type.CHESTPLATE -> "trims/items/chestplate" + this.trimPathSuffix;
            case ArmorItem.Type.LEGGINGS -> "trims/items/leggings" + this.trimPathSuffix;
            case ArmorItem.Type.BOOTS -> "trims/items/boots" + this.trimPathSuffix;
        };
    }
}

