/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.enchantment.custom;

import com.toukun.mymod.enchantment.ModEnchantments;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class AgilityEnchantment
extends Enchantment {
    public static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.LEGS};

    public AgilityEnchantment(EnchantmentCategory enchantmentCategory) {
        super(Enchantment.Rarity.UNCOMMON, enchantmentCategory, EQUIPMENT_SLOTS);
    }

    public static int getDashReduction(int level) {
        return switch (level) {
            case 3 -> 7;
            case 2 -> 5;
            case 1 -> 2;
            default -> 0;
        };
    }

    public int getMaxLevel() {
        return 3;
    }

    public int getMinCost(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 8;
    }

    public int getMaxCost(int enchantmentLevel) {
        return this.getMinCost(enchantmentLevel) + 8;
    }

    protected boolean checkCompatibility(Enchantment enchantment) {
        return super.checkCompatibility(enchantment) && enchantment != ModEnchantments.LEAP.get();
    }
}

