/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.enchantment.custom;

import com.toukun.mymod.enchantment.ModEnchantments;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class LeapEnchantment
extends Enchantment {
    public static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.LEGS};

    public LeapEnchantment(EnchantmentCategory enchantmentCategory) {
        super(Enchantment.Rarity.UNCOMMON, enchantmentCategory, EQUIPMENT_SLOTS);
    }

    public static double getDashHeightBonus(int level) {
        return switch (level) {
            case 3 -> 0.4;
            case 2 -> 0.2;
            case 1 -> 0.1;
            default -> 0.0;
        };
    }

    public int getMaxLevel() {
        return 3;
    }

    public int getMinCost(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 8;
    }

    public int getMaxCost(int enchantmentLevel) {
        return this.getMinCost(enchantmentLevel) + 8;
    }

    protected boolean checkCompatibility(Enchantment enchantment) {
        return super.checkCompatibility(enchantment) && enchantment != ModEnchantments.AGILITY.get();
    }
}

