/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.enchantment.custom;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.Enchantments;

public class LifeStealEnchantment
extends Enchantment {
    public static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.MAINHAND};

    public LifeStealEnchantment(EnchantmentCategory enchantmentCategory) {
        super(Enchantment.Rarity.VERY_RARE, enchantmentCategory, EQUIPMENT_SLOTS);
    }

    public void doPostAttack(LivingEntity owner, Entity target, int damage) {
        int level = owner.getMainHandItem().getEnchantmentLevel((Enchantment)this);
        if (target instanceof LivingEntity && owner.getRandom().nextFloat() < 0.02f * (float)level) {
            owner.setHealth(owner.getHealth() + 2.0f);
        }
    }

    public int getMaxLevel() {
        return 2;
    }

    public int getMinCost(int enchantmentLevel) {
        return 10 + (enchantmentLevel - 1) * 12;
    }

    public int getMaxCost(int enchantmentLevel) {
        return this.getMinCost(enchantmentLevel) + 12;
    }

    protected boolean checkCompatibility(Enchantment enchantment) {
        return super.checkCompatibility(enchantment) && enchantment != Enchantments.FIRE_ASPECT;
    }
}

