/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.enchantment.custom;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class QuickCastEnchantment
extends Enchantment {
    public static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.MAINHAND};

    public QuickCastEnchantment(EnchantmentCategory pCategory) {
        super(Enchantment.Rarity.UNCOMMON, pCategory, EQUIPMENT_SLOTS);
    }

    public static float GetCooldownMultiplier(int level) {
        return switch (level) {
            default -> 1.0f;
            case 1 -> 0.95f;
            case 2 -> 0.9f;
            case 3 -> 0.8f;
        };
    }

    public int getMaxLevel() {
        return 3;
    }

    public int getMinCost(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 8;
    }

    public int getMaxCost(int enchantmentLevel) {
        return this.getMinCost(enchantmentLevel) + 8;
    }
}

