/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.enchantment.custom;

import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class SpellPowerEnchantment
extends Enchantment {
    public static final EquipmentSlot[] EQUIPMENT_SLOTS = new EquipmentSlot[]{EquipmentSlot.MAINHAND};

    public SpellPowerEnchantment(EnchantmentCategory category) {
        super(Enchantment.Rarity.COMMON, category, EQUIPMENT_SLOTS);
    }

    public static float GetDamageMultiplier(int level) {
        return switch (level) {
            default -> 1.0f;
            case 1 -> 1.1f;
            case 2 -> 1.2f;
            case 3 -> 1.3f;
            case 4 -> 1.4f;
            case 5 -> 1.5f;
        };
    }

    public int getMinCost(int level) {
        return 1 + (level - 1) * 11;
    }

    public int getMaxCost(int level) {
        return this.getMinCost(level) + 20;
    }

    public int getMaxLevel() {
        return 5;
    }
}

