/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.entity.classes;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public abstract class AbstractDamageProjectile
extends Projectile
implements ItemSupplier {
    public static String POWER_TAG = "power";
    public static String DAMAGE_TAG = "damage";
    public double xPower;
    public double yPower;
    public double zPower;
    protected ParticleOptions trailParticles = ParticleTypes.WHITE_SMOKE;
    protected float damage = 2.0f;

    protected AbstractDamageProjectile(EntityType<? extends AbstractDamageProjectile> type, Level level) {
        super(type, level);
    }

    protected AbstractDamageProjectile(EntityType<? extends AbstractDamageProjectile> type, Level level, double x, double y, double z) {
        super(type, level);
        this.setPos(x, y, z);
    }

    public AbstractDamageProjectile(EntityType<? extends AbstractDamageProjectile> type, Level level, double x, double y, double z, double offsetX, double offsetY, double offsetZ) {
        this(type, level);
        this.moveTo(x, y, z, this.getYRot(), this.getXRot());
        this.reapplyPosition();
        double vectorPower = Math.sqrt(offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ);
        if (vectorPower != 0.0) {
            this.xPower = offsetX / vectorPower * 0.1;
            this.yPower = offsetY / vectorPower * 0.1;
            this.zPower = offsetZ / vectorPower * 0.1;
        }
    }

    public AbstractDamageProjectile(EntityType<? extends AbstractDamageProjectile> type, Level level, LivingEntity owner, double offsetX, double offsetY, double offsetZ) {
        this(type, level, owner.getX(), owner.getY(), owner.getZ(), offsetX, offsetY, offsetZ);
        this.setOwner((Entity)owner);
        this.setRot(owner.getYRot(), owner.getXRot());
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    protected void defineSynchedData() {
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        double boundingBoxSize = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(boundingBoxSize)) {
            boundingBoxSize = 4.0;
        }
        return pDistance < (boundingBoxSize *= 64.0) * boundingBoxSize;
    }

    protected ClipContext.Block getClipType() {
        return ClipContext.Block.COLLIDER;
    }

    protected boolean canHitEntity(Entity target) {
        return super.canHitEntity(target) && !target.noPhysics;
    }

    protected ParticleOptions getTrailParticle() {
        return this.trailParticles;
    }

    protected float getInertia() {
        return this.isInWater() ? 0.8f : 0.95f;
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.put(POWER_TAG, (Tag)this.newDoubleList(new double[]{this.xPower, this.yPower, this.zPower}));
        compoundTag.putFloat(DAMAGE_TAG, this.damage);
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        ListTag listtag;
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains(POWER_TAG, 9) && (listtag = compoundTag.getList(POWER_TAG, 6)).size() == 3) {
            this.xPower = listtag.getDouble(0);
            this.yPower = listtag.getDouble(1);
            this.zPower = listtag.getDouble(2);
        }
        if (compoundTag.contains(DAMAGE_TAG)) {
            this.damage = compoundTag.getFloat(DAMAGE_TAG);
        }
    }

    public boolean isPickable() {
        return true;
    }

    public float getPickRadius() {
        return 1.0f;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markHurt();
        Entity entity = source.getEntity();
        if (entity != null) {
            if (!this.level().isClientSide) {
                Vec3 vec3 = entity.getLookAngle();
                this.setDeltaMovement(vec3);
                this.xPower = vec3.x * 0.1;
                this.yPower = vec3.y * 0.1;
                this.zPower = vec3.z * 0.1;
                this.setOwner(entity);
            }
            return true;
        }
        return false;
    }

    public float getLightLevelDependentMagicValue() {
        return 1.0f;
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket() {
        Entity entity = this.getOwner();
        int i = entity == null ? 0 : entity.getId();
        return new ClientboundAddEntityPacket(this.getId(), this.getUUID(), this.getX(), this.getY(), this.getZ(), this.getXRot(), this.getYRot(), this.getType(), i, new Vec3(this.xPower, this.yPower, this.zPower), 0.0);
    }

    public void recreateFromPacket(ClientboundAddEntityPacket packet) {
        super.recreateFromPacket(packet);
        double d0 = packet.getXa();
        double d1 = packet.getYa();
        double d2 = packet.getZa();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.xPower = d0 / d3 * 0.1;
            this.yPower = d1 / d3 * 0.1;
            this.zPower = d2 / d3 * 0.1;
        }
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), this.damage);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }

    public void tick() {
        Entity entity = this.getOwner();
        if (this.level().isClientSide || (entity == null || !entity.isRemoved()) && this.level().isAreaLoaded(this.blockPosition(), 4)) {
            super.tick();
            HitResult hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, this::canHitEntity, (ClipContext.Block)this.getClipType());
            if (hitresult.getType() != HitResult.Type.MISS && !EventHooks.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
                this.onHit(hitresult);
            }
            this.checkInsideBlocks();
            Vec3 vec3 = this.getDeltaMovement();
            double deltaX = this.getX() + vec3.x;
            double deltaY = this.getY() + vec3.y;
            double deltaZ = this.getZ() + vec3.z;
            ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
            this.setDeltaMovement(vec3.add(this.xPower, this.yPower, this.zPower).scale((double)this.getInertia()));
            ParticleOptions particleoptions = this.getTrailParticle();
            if (particleoptions != null) {
                this.level().addParticle(particleoptions, deltaX, deltaY + 0.1, deltaZ, 0.0, 0.0, 0.0);
            }
            this.setPos(deltaX, deltaY, deltaZ);
        } else {
            this.discard();
        }
    }

    public static interface ProjectileEntityFactory<T extends AbstractDamageProjectile> {
        public T create(Level var1, LivingEntity var2, double var3, double var5, double var7);
    }
}

