/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.entity.classes;

import com.toukun.mymod.entity.classes.AbstractDamageProjectile;
import com.toukun.mymod.entity.classes.Projectile;
import com.toukun.mymod.entity.custom.MagicBoltEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public enum Projectiles implements Projectile
{
    STANDARD_MAGIC_BOLT(2, 10, 1, SoundEvents.SHULKER_SHOOT, MagicBoltEntity::new);

    private final int baseDamage;
    private final int useTime;
    private final int durabilityCost;
    private final SoundEvent soundEvent;
    private final AbstractDamageProjectile.ProjectileEntityFactory<AbstractDamageProjectile> projectileEntityFactory;

    private Projectiles(int baseDamage, int useTime, int durabilityCost, SoundEvent soundEvent, AbstractDamageProjectile.ProjectileEntityFactory<AbstractDamageProjectile> factory) {
        this.baseDamage = baseDamage;
        this.useTime = useTime;
        this.durabilityCost = durabilityCost;
        this.soundEvent = soundEvent;
        this.projectileEntityFactory = factory;
    }

    @Override
    public int getBaseDamage() {
        return this.baseDamage;
    }

    @Override
    public int getUseTime() {
        return this.useTime;
    }

    @Override
    public int getDurabilityCost() {
        return this.durabilityCost;
    }

    @Override
    public SoundEvent getCastSound() {
        return this.soundEvent;
    }

    @Override
    public AbstractDamageProjectile getProjectile(Level level, LivingEntity owner, double x, double y, double z) {
        return this.projectileEntityFactory.create(level, owner, x, y, z);
    }
}

