/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.entity.custom;

import com.toukun.mymod.entity.ModEntityTypes;
import com.toukun.mymod.item.ModItems;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class SunlightSpearEntity
extends ThrowableItemProjectile {
    public static final float DAMAGE = 20.0f;

    public SunlightSpearEntity(EntityType<? extends SunlightSpearEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SunlightSpearEntity(Level level, LivingEntity livingEntity) {
        super(ModEntityTypes.SUNLIGHT_SPEAR.get(), livingEntity, level);
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.SUNLIGHT_SPEAR.get();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), 20.0f);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.discard();
        }
        this.playSound(SoundEvents.LIGHTNING_BOLT_IMPACT, 0.5f, 1.0f);
    }
}

