/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.entity.custom;

import com.toukun.mymod.entity.ModEntityTypes;
import com.toukun.mymod.item.ModItems;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrowingKnifeEntity
extends ThrowableItemProjectile {
    private int damage = 2;

    public ThrowingKnifeEntity(EntityType<? extends ThrowingKnifeEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ThrowingKnifeEntity(Level level, LivingEntity livingEntity) {
        super(ModEntityTypes.THROWING_KNIFE.get(), livingEntity, level);
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    protected Item getDefaultItem() {
        return (Item)ModItems.IRON_THROWING_KNIFE.get();
    }

    protected void onHitEntity(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.getEntity();
        entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)this.damage);
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.discard();
        }
    }
}

