/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.event;

import com.toukun.mymod.client.dash.ClientDashData;
import com.toukun.mymod.client.dash.DashHUDOverlay;
import com.toukun.mymod.client.gui.CompassHUDOverlay;
import com.toukun.mymod.client.gui.SwingTimerHUDOverlay;
import com.toukun.mymod.client.hearth.ClientHearthData;
import com.toukun.mymod.client.hearth.HearthHUDOverlay;
import com.toukun.mymod.client.party.ClientPartyData;
import com.toukun.mymod.client.party.PartyHUDOverlay;
import com.toukun.mymod.client.sizedBundles.ClientSizedBundleTooltip;
import com.toukun.mymod.entity.ModEntityTypes;
import com.toukun.mymod.item.ModItems;
import com.toukun.mymod.item.classes.SizedBundleItem;
import com.toukun.mymod.item.classes.SizedBundleTooltip;
import com.toukun.mymod.keybind.ModKeyBindings;
import com.toukun.mymod.network.packets.DashPacket;
import com.toukun.mymod.network.packets.HearthPacket;
import com.toukun.mymod.network.packets.OpenMenuPacket;
import com.toukun.mymod.screen.ModMenuTypes;
import com.toukun.mymod.screen.party.PartyScreen;
import com.toukun.mymod.screen.questBoard.QuestBoardScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.neoforged.neoforge.client.event.RegisterGuiOverlaysEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {

    @Mod.EventBusSubscriber(modid="toukun", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModBusEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            ModEntityTypes.onClientSetup();
            event.enqueueWork(() -> ItemProperties.register((Item)((Item)ModItems.SHULKER_BUNDLE.get()), (ResourceLocation)new ResourceLocation("toukun", "filled"), (itemStack, clientLevel, livingEntity, number) -> SizedBundleItem.getFullnessDisplay(itemStack)));
        }

        @SubscribeEvent
        public static void onScreenRegister(RegisterMenuScreensEvent event) {
            event.register(ModMenuTypes.QUEST_BOARD_MENU.get(), QuestBoardScreen::new);
            event.register(ModMenuTypes.PARTY_MENU.get(), PartyScreen::new);
        }

        @SubscribeEvent
        public static void onKeyRegister(RegisterKeyMappingsEvent event) {
            ModKeyBindings.register(event);
        }

        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
            event.registerAboveAll(new ResourceLocation("toukun", "dash"), DashHUDOverlay.HUD_DASH);
            event.registerAboveAll(new ResourceLocation("toukun", "coords"), CompassHUDOverlay.HUD_COMPASS);
            event.registerAboveAll(new ResourceLocation("toukun", "swing_timer"), SwingTimerHUDOverlay.HUD_SWING_TIMER);
            event.registerAboveAll(new ResourceLocation("toukun", "hearth"), HearthHUDOverlay.HUD_HEARTH);
            event.registerAboveAll(new ResourceLocation("toukun", "party"), PartyHUDOverlay.HUD_PARTY);
        }

        @SubscribeEvent
        public static void onRegisterClientTooltipComponents(RegisterClientTooltipComponentFactoriesEvent event) {
            event.register(SizedBundleTooltip.class, ClientSizedBundleTooltip::new);
        }
    }

    @Mod.EventBusSubscriber(modid="toukun", value={Dist.CLIENT})
    public static class ClientNeoforgeEvents {
        @SubscribeEvent
        public static void onKeyInput(InputEvent.Key event) {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player == null) {
                return;
            }
            if (ModKeyBindings.DASH_KEY.consumeClick() && player.isAlive() && !player.isSleeping() && player.onGround()) {
                if (ClientDashData.dashReady()) {
                    PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new DashPacket(0)});
                } else {
                    ClientDashData.setImpatient(8);
                }
            }
            if (ModKeyBindings.HEARTH_KEY.consumeClick() && player.isAlive() && !player.isSleeping()) {
                if (ClientHearthData.hearthReady()) {
                    PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new HearthPacket(0)});
                } else {
                    ClientHearthData.setImpatient(8);
                }
            }
            if (ModKeyBindings.QUEST_JOURNAL_KEY.consumeClick() && player.isAlive() && !player.isSleeping() && !player.inventoryMenu.active && !player.hasContainerOpen()) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenMenuPacket(1)});
            }
            if (ModKeyBindings.PARTY_KEY.consumeClick() && player.isAlive() && !player.isSleeping() && !player.inventoryMenu.active && !player.hasContainerOpen()) {
                PacketDistributor.SERVER.noArg().send(new CustomPacketPayload[]{new OpenMenuPacket(2)});
            }
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase.equals((Object)TickEvent.Phase.END)) {
                return;
            }
            if (!ClientDashData.dashReady() || ClientDashData.isImpatient()) {
                ClientDashData.tick();
            }
            if (!ClientHearthData.hearthReady() || ClientHearthData.isImpatient()) {
                ClientHearthData.tick();
            }
            if (!ClientPartyData.canTeleport()) {
                ClientPartyData.tick();
            }
        }
    }
}

