/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.event;

import com.mojang.brigadier.CommandDispatcher;
import com.toukun.mymod.attachments.dash.DashAttachmentHandler;
import com.toukun.mymod.attachments.hearth.HearthAttachmentHandler;
import com.toukun.mymod.attachments.party.PartyTeleportAttachmentHelper;
import com.toukun.mymod.commands.HearthCommand;
import com.toukun.mymod.commands.PartyCommand;
import com.toukun.mymod.config.Config;
import com.toukun.mymod.network.packets.DashPacket;
import com.toukun.mymod.network.packets.HearthPacket;
import com.toukun.mymod.network.packets.PartyTeleportPacket;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

@Mod.EventBusSubscriber(modid="toukun")
public class ModEvents {
    private static final String DEATH_MESSAGE = "system.toukun.message.death";

    @SubscribeEvent
    public static void onCommandRegister(RegisterCommandsEvent event) {
        HearthCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PartyCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath() && event.getOriginal().level().getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY)) {
            Player player = event.getEntity();
            int penalty = -((Integer)Config.DEATH_PENALTY.get()).intValue();
            player.giveExperienceLevels(penalty);
            player.sendSystemMessage((Component)Component.translatable((String)DEATH_MESSAGE, (Object[])new Object[]{Math.abs(penalty)}));
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        Player player;
        if (event.side.isServer() && event.phase.equals((Object)TickEvent.Phase.START) && (player = event.player) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            DashAttachmentHandler.Tick(player2);
            HearthAttachmentHandler.Tick(player2);
            PartyTeleportAttachmentHelper.Tick(player2);
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().isClientSide && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.connection.send((CustomPacketPayload)new DashPacket(DashAttachmentHandler.GetDashCooldown(player)));
            player.connection.send((CustomPacketPayload)new HearthPacket(HearthAttachmentHandler.GetHearthCooldown(player)));
            player.connection.send((CustomPacketPayload)new PartyTeleportPacket(PartyTeleportAttachmentHelper.GetPartyTeleportCooldown(player), player.getUUID()));
        }
    }
}

