/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.classes;

import com.toukun.mymod.item.classes.CooldownItem;
import com.toukun.mymod.item.classes.IUseTimeItem;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class CastingItem
extends CooldownItem
implements IUseTimeItem {
    protected final int useTime;

    public CastingItem(Item.Properties pProperties, int cooldown, int useTime) {
        super(pProperties, cooldown);
        this.useTime = useTime;
        this.toolTipBuilder.addUseTime(useTime);
    }

    @Override
    public float getUseTimePercentage(ItemStack itemstack, int ticksUsingItem) {
        if ((float)ticksUsingItem < 0.0f) {
            return 0.0f;
        }
        return Math.min((float)ticksUsingItem / (float)this.useTime, 1.0f);
    }

    public int getUseDuration(ItemStack itemStack) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int time) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            InteractionHand hand = player.getUsedItemHand();
            int usedTime = this.getUseDuration(itemStack);
            int used = usedTime - time;
            if (used >= this.useTime) {
                if (!level.isClientSide) {
                    this.onUseServer(level, player, hand, itemStack);
                    if (!player.isCreative()) {
                        player.getCooldowns().addCooldown((Item)this, this.cooldown);
                    }
                }
                this.onUseClient(level, player, hand, itemStack);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }
}

