/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.classes;

import com.toukun.mymod.utility.ToolTipBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class CooldownItem
extends Item {
    protected final ToolTipBuilder toolTipBuilder;
    protected final int cooldown;

    public CooldownItem(Item.Properties pProperties, int cooldown) {
        super(pProperties);
        this.cooldown = cooldown;
        this.toolTipBuilder = new ToolTipBuilder().addCoolDown(this.cooldown);
    }

    protected abstract void onUseServer(Level var1, Player var2, InteractionHand var3, ItemStack var4);

    protected abstract void onUseClient(Level var1, Player var2, InteractionHand var3, ItemStack var4);

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            this.onUseServer(level, player, hand, itemStack);
            if (!player.isCreative()) {
                player.getCooldowns().addCooldown((Item)this, this.cooldown);
            }
        }
        this.onUseClient(level, player, hand, itemStack);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide());
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        this.toolTipBuilder.build(components);
    }
}

