/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.classes;

import com.toukun.mymod.utility.ArmorMapUtils;
import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public enum ModArmorMaterials implements ArmorMaterial
{
    NETHERITE_CHAINMAIL("netherite_chainmail", 27, ArmorMapUtils.CreateArmorTypeMap(1, 4, 5, 2), 15, SoundEvents.ARMOR_EQUIP_NETHERITE, 1.0f, 0.0f, () -> Ingredient.of((ItemLike[])new ItemLike[]{Items.NETHERITE_INGOT}));

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_BY_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionMap;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final Supplier<Ingredient> repairIngredient;

    private ModArmorMaterials(String name, int durabilityMultiplier, EnumMap<ArmorItem.Type, Integer> protectionMap, int enchantmentValue, SoundEvent soundEvent, float toughness, float knockback, Supplier<Ingredient> repairIngredientSupplier) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.protectionMap = protectionMap;
        this.enchantmentValue = enchantmentValue;
        this.sound = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockback;
        this.repairIngredient = repairIngredientSupplier;
    }

    public int getDurabilityForType(ArmorItem.Type armorType) {
        return HEALTH_BY_TYPE.get(armorType) * this.durabilityMultiplier;
    }

    public int getDefenseForType(ArmorItem.Type armorType) {
        return this.protectionMap.get(armorType);
    }

    public int getEnchantmentValue() {
        return this.enchantmentValue;
    }

    public SoundEvent getEquipSound() {
        return this.sound;
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient.get();
    }

    public String getName() {
        return "toukun:" + this.name;
    }

    public float getToughness() {
        return this.toughness;
    }

    public float getKnockbackResistance() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_BY_TYPE = ArmorMapUtils.CreateArmorTypeMap(13, 15, 16, 11);
    }
}

