/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.classes;

import com.toukun.mymod.item.classes.CustomTabPopulator;
import com.toukun.mymod.quests.InvalidQuestIDException;
import com.toukun.mymod.quests.QuestData;
import com.toukun.mymod.quests.QuestTier;
import com.toukun.mymod.utility.ToolTipBuilder;
import java.util.List;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import org.jetbrains.annotations.Nullable;

public class QuestLogItem
extends Item
implements CustomTabPopulator {
    public static final String NBT_QUEST_TAG = "questID";
    public static final String QUEST_FAIL_NO_ITEM = "quest.toukun.failed.no_item";
    public static final String QUEST_FAIL_NOT_ENOUGH = "quest.toukun.failed.not_enough";
    public static final String QUEST_INVALID_ID = "quest.toukun.invalid_id";
    public static final String QUEST_COMPLETE = "quest.toukun.complete";
    public static final String QUEST_REWARD_SINGULAR = "quest.toukun.reward.singular";
    public static final String QUEST_REWARD_PLURAL = "quest.toukun.reward.plural";
    public static final String QUEST_DESCRIPTION_BASE = "quest.toukun.description.base";
    public static final String QUEST_DESCRIPTION_SINGULAR = "quest.toukun.description.singular";
    public static final String QUEST_DESCRIPTION_PLURAL = "quest.toukun.description.plural";
    public static final String QUEST_DESCRIPTION_INSTRUCTIONS = "quest.toukun.description.instructions";
    private static final int STACK_SIZE = 1;
    private final QuestTier questTier;

    public QuestLogItem(Item.Properties properties, QuestTier questTier) {
        super(properties.stacksTo(1));
        this.questTier = questTier;
    }

    @Nullable
    public static QuestTier GetQuestTier(ItemStack itemStack) {
        Item item = itemStack.getItem();
        if (item instanceof QuestLogItem) {
            return ((QuestLogItem)item).getQuestTier();
        }
        return null;
    }

    public static byte GetQuestID(ItemStack itemStack) {
        CompoundTag compoundTag = itemStack.getOrCreateTag();
        if (compoundTag.contains(NBT_QUEST_TAG)) {
            return compoundTag.getByte(NBT_QUEST_TAG);
        }
        return 0;
    }

    public static void SetQuestID(ItemStack itemStack, byte questID) {
        CompoundTag compoundTag = itemStack.getOrCreateTag();
        compoundTag.putByte(NBT_QUEST_TAG, questID);
        itemStack.setTag(compoundTag);
    }

    public QuestData getQuestData(byte questID) {
        try {
            return this.questTier.getQuestData(questID);
        }
        catch (InvalidQuestIDException e) {
            return new QuestData("", 0);
        }
    }

    public QuestTier getQuestTier() {
        return this.questTier;
    }

    public QuestData getQuestData(ItemStack itemStack) {
        return this.getQuestData(QuestLogItem.GetQuestID(itemStack));
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level level, List<Component> components, TooltipFlag flag) {
        byte questID = QuestLogItem.GetQuestID(itemStack);
        components.add((Component)Component.translatable((String)QUEST_DESCRIPTION_BASE, (Object[])new Object[]{questID}));
        QuestData questData = this.getQuestData(questID);
        int itemQuantity = questData.itemQuantity();
        if (itemQuantity == 1) {
            components.add((Component)Component.translatable((String)QUEST_DESCRIPTION_SINGULAR, (Object[])new Object[]{Component.translatable((String)questData.itemDescriptionID())}));
        } else {
            components.add((Component)Component.translatable((String)QUEST_DESCRIPTION_PLURAL, (Object[])new Object[]{itemQuantity, Component.translatable((String)questData.itemDescriptionID())}));
        }
        components.add(ToolTipBuilder.getNewLineComponent());
        components.add((Component)Component.translatable((String)QUEST_DESCRIPTION_INSTRUCTIONS));
    }

    protected void playerQuestCleanup(ItemStack itemStack, Player player, String questItemDescriptionID, int questItemQuantity) {
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
            player.getInventory().clearOrCountMatchingItems(pItemstack -> Objects.equals(questItemDescriptionID, pItemstack.getDescriptionId()), questItemQuantity, (Container)player.inventoryMenu.getCraftSlots());
        }
    }

    protected void playerQuestReward(ServerLevel level, Player player) {
        LootParams lootParams = new LootParams.Builder(level).create(LootContextParamSets.EMPTY);
        LootContextParamSet emptySet = LootContextParamSets.EMPTY;
        LootTable table = this.questTier.getLootTable();
        Inventory inventory = player.getInventory();
        for (ItemStack lootItemStack : table.getRandomItems(lootParams)) {
            boolean result;
            int rewardSize = lootItemStack.getCount();
            String descriptionId = lootItemStack.getDescriptionId();
            if (rewardSize == 1) {
                player.sendSystemMessage((Component)Component.translatable((String)QUEST_REWARD_SINGULAR, (Object[])new Object[]{Component.translatable((String)descriptionId)}));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)QUEST_REWARD_PLURAL, (Object[])new Object[]{lootItemStack.getCount(), Component.translatable((String)descriptionId)}));
            }
            if (result = inventory.add(lootItemStack)) continue;
            player.drop(lootItemStack, false);
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (!level.isClientSide) {
            ItemStack itemStack = player.getItemInHand(hand);
            QuestData questData = this.getQuestData(itemStack);
            String questItemDescriptionID = questData.itemDescriptionID();
            int questItemQuantity = questData.itemQuantity();
            if (questData.isInvalid()) {
                player.sendSystemMessage((Component)Component.translatable((String)QUEST_INVALID_ID, (Object[])new Object[]{QuestLogItem.GetQuestID(itemStack)}));
            } else {
                int itemCount = player.getInventory().clearOrCountMatchingItems(pItemstack -> Objects.equals(questItemDescriptionID, pItemstack.getDescriptionId()), 0, (Container)player.inventoryMenu.getCraftSlots());
                if (itemCount >= questItemQuantity) {
                    player.sendSystemMessage((Component)Component.translatable((String)QUEST_COMPLETE));
                    level.playSound(null, (Entity)player, SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, SoundSource.PLAYERS, 0.8f, 1.0f);
                    this.playerQuestCleanup(itemStack, player, questItemDescriptionID, questItemQuantity);
                    this.playerQuestReward((ServerLevel)level, player);
                } else if (itemCount > 0) {
                    player.sendSystemMessage((Component)Component.translatable((String)QUEST_FAIL_NOT_ENOUGH, (Object[])new Object[]{Component.translatable((String)questItemDescriptionID), itemCount, questItemQuantity}));
                } else {
                    player.sendSystemMessage((Component)Component.translatable((String)QUEST_FAIL_NO_ITEM));
                }
            }
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide);
    }

    @Override
    public void populateItemCategory(BuildCreativeModeTabContentsEvent event) {
        for (byte key : this.questTier.getQuestIDs()) {
            ItemStack tabStack = new ItemStack((ItemLike)this, 1);
            QuestLogItem.SetQuestID(tabStack, key);
            event.accept(tabStack);
        }
    }
}

