/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.classes;

import com.toukun.mymod.item.classes.SizedBundleTooltip;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SizedBundleItem
extends BundleItem {
    private static final String TAG_ITEMS = "Items";
    private static final String TAG_BEES = "Bees";
    private static final int BUNDLE_IN_BUNDLE_WEIGHT = 4;
    private static final int ORIGINAL_BUNDLE_MAX_WEIGHT = 64;
    private final int maxWeight;

    public SizedBundleItem(Item.Properties properties, int bundleSize) {
        super(properties);
        this.maxWeight = bundleSize;
    }

    public static float getFullnessDisplay(ItemStack bundleStack) {
        return (float)SizedBundleItem.getContentWeight(bundleStack) / (float)SizedBundleItem.getMaxWeight(bundleStack);
    }

    private static int getMaxWeight(ItemStack bundle) {
        int n;
        Item item = bundle.getItem();
        if (item instanceof SizedBundleItem) {
            SizedBundleItem sizedBundleItem = (SizedBundleItem)item;
            n = sizedBundleItem.maxWeight;
        } else {
            n = 64;
        }
        return n;
    }

    private static int getContentWeight(ItemStack bundle) {
        return SizedBundleItem.getContents(bundle).mapToInt(item -> SizedBundleItem.getWeight(item) * item.getCount()).sum();
    }

    private static Stream<ItemStack> getContents(ItemStack bundle) {
        CompoundTag compoundtag = bundle.getTag();
        if (compoundtag == null) {
            return Stream.empty();
        }
        ListTag listtag = compoundtag.getList(TAG_ITEMS, 10);
        return listtag.stream().map(CompoundTag.class::cast).map(ItemStack::of);
    }

    private static int getWeight(ItemStack item) {
        CompoundTag compoundtag;
        if (item.is(Items.BUNDLE)) {
            return 4 + SizedBundleItem.getContentWeight(item);
        }
        if ((item.is(Items.BEEHIVE) || item.is(Items.BEE_NEST)) && item.hasTag() && (compoundtag = BlockItem.getBlockEntityData((ItemStack)item)) != null && !compoundtag.getList(TAG_BEES, 10).isEmpty()) {
            return 64;
        }
        return 64 / item.getMaxStackSize();
    }

    private static void addNewItemStackTag(ListTag list, ItemStack original, int amount) {
        CompoundTag newTag = new CompoundTag();
        original.copyWithCount(amount).save(newTag);
        list.add(0, (Tag)newTag);
    }

    private static int add(ItemStack bundle, ItemStack itemStack) {
        if (itemStack.isEmpty() || !itemStack.getItem().canFitInsideContainerItems()) {
            return 0;
        }
        CompoundTag compoundtag = bundle.getOrCreateTag();
        if (!compoundtag.contains(TAG_ITEMS)) {
            compoundtag.put(TAG_ITEMS, (Tag)new ListTag());
        }
        int bundleMaxWeight = SizedBundleItem.getMaxWeight(bundle);
        int bundleWeight = SizedBundleItem.getContentWeight(bundle);
        int itemWeight = SizedBundleItem.getWeight(itemStack);
        int spaceAvailable = Math.min(itemStack.getCount(), (bundleMaxWeight - bundleWeight) / itemWeight);
        if (spaceAvailable == 0) {
            return 0;
        }
        ListTag listtag = compoundtag.getList(TAG_ITEMS, 10);
        Optional<CompoundTag> optional = SizedBundleItem.getMatchingItem(itemStack, listtag);
        if (optional.isEmpty()) {
            SizedBundleItem.addNewItemStackTag(listtag, itemStack, spaceAvailable);
            return spaceAvailable;
        }
        CompoundTag existingTag = optional.get();
        ItemStack existingStack = ItemStack.of((CompoundTag)existingTag);
        int existingStackAvailableSpace = existingStack.getMaxStackSize() - existingStack.getCount();
        boolean overflow = spaceAvailable > existingStackAvailableSpace;
        existingStack.grow(overflow ? existingStackAvailableSpace : spaceAvailable);
        existingStack.save(existingTag);
        listtag.remove((Object)existingTag);
        listtag.add(0, (Tag)existingTag);
        if (!overflow) {
            return spaceAvailable;
        }
        int overflowAmount = spaceAvailable - existingStackAvailableSpace;
        SizedBundleItem.addNewItemStackTag(listtag, itemStack, overflowAmount);
        existingStack.grow(existingStackAvailableSpace);
        return spaceAvailable;
    }

    private static Optional<CompoundTag> getFirstPartialMatchingItem(ItemStack itemStack, ListTag itemListTag) {
        if (itemStack.is(Items.BUNDLE)) {
            return Optional.empty();
        }
        Stream<Tag> itemTagStream = itemListTag.stream();
        Objects.requireNonNull(CompoundTag.class);
        itemTagStream = itemTagStream.filter(CompoundTag.class::isInstance);
        Objects.requireNonNull(CompoundTag.class);
        return itemTagStream.map(CompoundTag.class::cast).filter(itemTag -> {
            ItemStack tagItemStack = ItemStack.of((CompoundTag)itemTag);
            if (!ItemStack.isSameItemSameTags((ItemStack)tagItemStack, (ItemStack)itemStack)) {
                return false;
            }
            return tagItemStack.getMaxStackSize() < tagItemStack.getCount();
        }).findFirst();
    }

    private static Optional<CompoundTag> getMatchingItem(ItemStack itemStack, ListTag itemListTag) {
        if (itemStack.is(Items.BUNDLE)) {
            return Optional.empty();
        }
        Stream<Tag> itemTagStream = itemListTag.stream();
        Objects.requireNonNull(CompoundTag.class);
        itemTagStream = itemTagStream.filter(CompoundTag.class::isInstance);
        Objects.requireNonNull(CompoundTag.class);
        return itemTagStream.map(CompoundTag.class::cast).filter(itemTag -> ItemStack.isSameItemSameTags((ItemStack)ItemStack.of((CompoundTag)itemTag), (ItemStack)itemStack)).findFirst();
    }

    private static Optional<ItemStack> removeOne(ItemStack itemStack) {
        CompoundTag compoundtag = itemStack.getOrCreateTag();
        if (!compoundtag.contains(TAG_ITEMS)) {
            return Optional.empty();
        }
        ListTag listtag = compoundtag.getList(TAG_ITEMS, 10);
        if (listtag.isEmpty()) {
            return Optional.empty();
        }
        CompoundTag compoundTag1 = listtag.getCompound(0);
        ItemStack itemstack = ItemStack.of((CompoundTag)compoundTag1);
        listtag.remove(0);
        if (listtag.isEmpty()) {
            itemStack.removeTagKey(TAG_ITEMS);
        }
        return Optional.of(itemstack);
    }

    private static boolean dropContents(ItemStack bundle, Player player) {
        CompoundTag bundleTag = bundle.getOrCreateTag();
        if (!bundleTag.contains(TAG_ITEMS)) {
            return false;
        }
        if (player instanceof ServerPlayer) {
            ListTag listtag = bundleTag.getList(TAG_ITEMS, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag slotTag = listtag.getCompound(i);
                ItemStack itemstack = ItemStack.of((CompoundTag)slotTag);
                player.drop(itemstack, true);
            }
        }
        bundle.removeTagKey(TAG_ITEMS);
        return true;
    }

    public int getBarWidth(ItemStack bundle) {
        return Math.min(1 + 12 * SizedBundleItem.getContentWeight(bundle) / this.maxWeight, 13);
    }

    public boolean overrideStackedOnOther(ItemStack bundle, Slot itemSlot, ClickAction clickAction, Player player) {
        if (bundle.getCount() != 1 || clickAction != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack itemstack = itemSlot.getItem();
        if (itemstack.isEmpty()) {
            this.playRemoveOneSound((Entity)player);
            SizedBundleItem.removeOne(bundle).ifPresent(removedItem -> SizedBundleItem.add(bundle, itemSlot.safeInsert(removedItem)));
        } else if (itemstack.getItem().canFitInsideContainerItems()) {
            int bundleMaxWeight = SizedBundleItem.getMaxWeight(bundle);
            int takeAmount = (bundleMaxWeight - SizedBundleItem.getContentWeight(bundle)) / SizedBundleItem.getWeight(itemstack);
            int amountTaken = SizedBundleItem.add(bundle, itemSlot.safeTake(itemstack.getCount(), takeAmount, player));
            if (amountTaken > 0) {
                this.playInsertSound((Entity)player);
            }
        }
        return true;
    }

    public boolean overrideOtherStackedOnMe(ItemStack selfItemStack, ItemStack itemStack, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (selfItemStack.getCount() != 1) {
            return false;
        }
        if (clickAction != ClickAction.SECONDARY || !slot.allowModification(player)) {
            return false;
        }
        if (itemStack.isEmpty()) {
            SizedBundleItem.removeOne(selfItemStack).ifPresent(removedItem -> {
                this.playRemoveOneSound((Entity)player);
                slotAccess.set(removedItem);
            });
        } else {
            int i = SizedBundleItem.add(selfItemStack, itemStack);
            if (i > 0) {
                this.playInsertSound((Entity)player);
                itemStack.shrink(i);
            }
        }
        return true;
    }

    private void playRemoveOneSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_REMOVE_ONE, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity entity) {
        entity.playSound(SoundEvents.BUNDLE_INSERT, 0.8f, 0.8f + entity.level().getRandom().nextFloat() * 0.4f);
    }

    private void playDropContentsSound(Entity pEntity) {
        pEntity.playSound(SoundEvents.BUNDLE_DROP_CONTENTS, 0.8f, 0.8f + pEntity.level().getRandom().nextFloat() * 0.4f);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack bundle) {
        NonNullList nonnulllist = NonNullList.create();
        Objects.requireNonNull(nonnulllist);
        SizedBundleItem.getContents(bundle).forEach(arg_0 -> nonnulllist.add(arg_0));
        return Optional.of(new SizedBundleTooltip((NonNullList<ItemStack>)nonnulllist, SizedBundleItem.getContentWeight(bundle), SizedBundleItem.getMaxWeight(bundle)));
    }

    public void appendHoverText(ItemStack bundle, Level level, List<Component> components, TooltipFlag tooltipFlag) {
        components.add((Component)Component.translatable((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{SizedBundleItem.getContentWeight(bundle), SizedBundleItem.getMaxWeight(bundle)}).withStyle(ChatFormatting.GRAY));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (SizedBundleItem.dropContents(itemstack, player)) {
            this.playDropContentsSound((Entity)player);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }
}

