/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.classes;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.toukun.mymod.utility.WeaponType;
import com.toukun.mymod.utility.WeaponTypes;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.neoforged.neoforge.common.NeoForgeMod;

public class WeaponItem
extends SwordItem {
    protected static final WeaponType DEFAULT_WEAPON_TYPE = WeaponTypes.VANILLA_SWORD;
    protected static final UUID KNOCK_BACK_UUID = UUID.fromString("47b9d30c-c8ab-486f-91cf-c3ce848d5aae");
    protected static final UUID ATTACK_RANGE_UUID = UUID.fromString("8c187b2c-8da5-4708-9e89-fea79af52da7");
    protected final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public WeaponItem(Tier tier, Item.Properties properties) {
        this(tier, properties, DEFAULT_WEAPON_TYPE.getBaseDamageAsInt(), DEFAULT_WEAPON_TYPE.getAttackSpeed(), DEFAULT_WEAPON_TYPE.getAttackKnockback(), DEFAULT_WEAPON_TYPE.getAttackRange());
    }

    public WeaponItem(Tier tier, Item.Properties properties, WeaponType weaponType) {
        this(tier, properties, weaponType.getBaseDamageAsInt(), weaponType.getAttackSpeed(), weaponType.getAttackKnockback(), weaponType.getAttackRange());
    }

    public WeaponItem(Tier tier, Item.Properties properties, int damage, float attackSpeed, float knockBack, float attackRange) {
        super(tier, damage, attackSpeed, properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Attack Damage modifier", (double)((float)damage + tier.getAttackDamageBonus()), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Attack Speed modifier", (double)attackSpeed, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.ATTACK_KNOCKBACK, (Object)new AttributeModifier(KNOCK_BACK_UUID, "Knock Back modifier", (double)knockBack, AttributeModifier.Operation.ADDITION));
        builder.put((Object)((Attribute)NeoForgeMod.ENTITY_REACH.value()), (Object)new AttributeModifier(ATTACK_RANGE_UUID, "Attack Range modifiers", (double)attackRange, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public Multimap<Attribute, AttributeModifier> getDefaultAttributeModifiers(EquipmentSlot slot) {
        return slot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.getDefaultAttributeModifiers(slot);
    }
}

