/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.classes.staves;

import com.toukun.mymod.enchantment.ModEnchantments;
import com.toukun.mymod.enchantment.custom.SpellPowerEnchantment;
import com.toukun.mymod.item.classes.staves.StaffItem;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class DamagingStaffItem
extends StaffItem {
    private final float damage;

    public DamagingStaffItem(Tier pTier, Item.Properties pProperties, int useTime, int durabilityCost, float damage) {
        super(pTier, pProperties, useTime, durabilityCost);
        this.damage = damage;
        this.toolTipBuilder.addDamage(this.damage);
    }

    protected float getSpellDamage(ItemStack itemStack) {
        int spellPowerLevel = itemStack.getEnchantmentLevel(ModEnchantments.SPELL_POWER.get());
        return this.damage * SpellPowerEnchantment.GetDamageMultiplier(spellPowerLevel);
    }

    @Override
    public void appendHoverText(ItemStack itemStack, @Nullable Level l, List<Component> components, TooltipFlag flag) {
        this.toolTipBuilder.addDamage(this.getSpellDamage(itemStack));
        super.appendHoverText(itemStack, l, components, flag);
    }
}

