/*
 * Decompiled with CFR 0.152.
 */
package com.toukun.mymod.item.classes.staves;

import com.toukun.mymod.enchantment.ModEnchantments;
import com.toukun.mymod.enchantment.custom.QuickCastEnchantment;
import com.toukun.mymod.item.classes.IUseTimeItem;
import com.toukun.mymod.utility.ToolTipBuilder;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public abstract class StaffItem
extends TieredItem
implements Vanishable,
IUseTimeItem {
    protected final ToolTipBuilder toolTipBuilder;
    protected final int durabilityCost;
    private final int useTime;

    public StaffItem(Tier pTier, Item.Properties pProperties, int useTime, int durabilityCost) {
        super(pTier, pProperties);
        this.useTime = useTime;
        this.durabilityCost = durabilityCost;
        this.toolTipBuilder = new ToolTipBuilder().addUseTime(useTime).addDurabilityCost(durabilityCost);
    }

    public void appendHoverText(ItemStack itemStack, @Nullable Level l, List<Component> components, TooltipFlag flag) {
        this.toolTipBuilder.addUseTime(this.getUseTime(itemStack)).build(components);
    }

    protected int getUseTime(ItemStack itemStack) {
        int level = itemStack.getEnchantmentLevel(ModEnchantments.QUICK_CAST.get());
        if (level == 0) {
            return this.useTime;
        }
        float multiplier = QuickCastEnchantment.GetCooldownMultiplier(level);
        return Math.round(multiplier * (float)this.useTime);
    }

    @Override
    public float getUseTimePercentage(ItemStack itemStack, int ticksUsingItem) {
        if ((float)ticksUsingItem < 0.0f) {
            return 0.0f;
        }
        return Math.min((float)ticksUsingItem / (float)this.getUseTime(itemStack), 1.0f);
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
    }

    protected abstract void onUseServer(Level var1, Player var2, InteractionHand var3, ItemStack var4);

    protected abstract void onUseClient(Level var1, Player var2, InteractionHand var3, ItemStack var4);

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int time) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            InteractionHand hand = player.getUsedItemHand();
            int usedTime = this.getUseDuration(itemStack);
            int used = usedTime - time;
            if (used >= this.getUseTime(itemStack)) {
                if (!level.isClientSide) {
                    if (!player.getAbilities().instabuild) {
                        itemStack.hurtAndBreak(this.durabilityCost, (LivingEntity)player, playerC -> playerC.broadcastBreakEvent(hand));
                    }
                    this.onUseServer(level, player, hand, itemStack);
                }
                this.onUseClient(level, player, hand, itemStack);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
        }
    }
}

